/* libpasori bsdugen */
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <dev/usb/usb.h>
#include <sys/ioctl.h>
#include <errno.h>

#include "libpasori_liblocal.h"

void dbg_dump(uint8* d,int size){
        int i;
        for(i=0;i!=size;i++){
                Log("%02X ",d[i]);
        }
        Log("\n");

} /* FIXME:DUMMY DEBUG FUNC */

pasori* pasori_open(char* c){ /* FIXME:unused arg. */
        int config;
        pasori *pp;
        char* pasori_devname;
        char* pasori_intr;
        int i;
        const int timeout = 400;
        const int size = 0;
        pp = (pasori *)malloc(sizeof(pasori));

        pasori_devname = "/dev/ugen0"; /* FIXME:hardcoded device path */
        pasori_intr = "/dev/ugen0.1";

        pp->fd_cntl = open(pasori_devname,O_RDWR);

        config = 1;
        i = ioctl(pp->fd_cntl,USB_SET_CONFIG,&config);
        pp->fd_intr = open(pasori_intr,O_RDONLY);
        if( (pp->fd_cntl < 0) || (pp->fd_intr < 0) ){
                Log("error opening pasori.");
                close(pp->fd_cntl);
                close(pp->fd_intr);
                free(pp);
        }
        ioctl(pp->fd_cntl,USB_SET_TIMEOUT,&timeout);

        *(long long *)pp->id = 0;
        pp->mdate = 0;
        return pp;
}

int pasori_send(pasori* pp,uint8 *cmd,uint8 size,int timeout){
        struct usb_ctl_request req;
        uint8 msg[128]; /* FIXME:max message bytes? */
        uint8 resp[256];
        signed int i;

        req.ucr_request.bmRequestType = (2 << 5); /* VENDOR SPEC. */
        req.ucr_request.bRequest = 0;
        USETW(req.ucr_request.wLength,size);
        USETW(req.ucr_request.wValue,0);
        USETW(req.ucr_request.wIndex,0);
        req.ucr_data = cmd;
        req.ucr_flags = 0;

        i = ioctl(pp->fd_cntl,USB_DO_REQUEST,&req);

        if(i<0){
                Log("FIXME");
                return 1; /* FIXME:XXXXXXXXX */
        }

        Log("(SEND OK)");
        dbg_dump(cmd,size);
        /* FIXME:insert recv */
        i = pasori_recv(pp,resp,255,timeout);
        dbg_dump(resp,i);

        return 0;
}

#define STATE_UNKNOWN 1
#define STATE_COMMAND 2

/* FIXME:PORT */
int pasori_recv(pasori* pp,uint8* buf,uint8 bufsize,int timeout){
        signed int i;
        int state;
        int size;
        int ptr;
        int one = 1;
        uint8 resp;
        state = STATE_UNKNOWN;

        ptr = 0;
        do{
                i = ioctl(pp->fd_cntl,USB_SET_TIMEOUT,&timeout);
                if(i<0){
                        Log("TIMEOUT errno = %d (%s) \n",errno,strerror(errno));
                }

                i = read(pp->fd_intr,&resp,1);
                Log("READ   --  (%d)\n",i);
                if(ptr == 3) { /* size */
                        if(resp == 0) {
                                size = 6;
                        }else{
                                size = 7+resp;
                        }
                        state = STATE_COMMAND;
                }

                buf[ptr] = resp;
                /* debug */
                dbg_dump(&resp,1);

                ptr++;

        }while((!(ptr==size)) || (!(state==STATE_COMMAND)));

        Log("(RECV OK)");
        dbg_dump(buf,size);
        return size+1;
}

void pasori_close(pasori* p){
        close(p->fd_intr);
        close(p->fd_cntl);
}

