/* libpasori bsdugen */
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <dev/usb/usb.h>
#include <sys/ioctl.h>
#include <errno.h>

#include "libpasori_liblocal.h"

void dbg_dump(uint8* d,int size){
        int i;
        for(i=0;i!=size;i++){
                Log("%02X ",d[i]);
        }
        Log("\n");
}

pasori* pasori_open(char* c){ /* FIXME:unused arg. */
        int config;
        pasori *pp;
        char* pasori_devname;
        char* pasori_intr;
        int i;
	int t;
        const int timeout = 400;
        const int size = 0;
        pp = (pasori *)malloc(sizeof(pasori));

        pasori_devname = "/dev/ugen0.00"; /* FIXME:hardcoded device path */
        pasori_intr = "/dev/ugen0.01";

        pp->fd_cntl = open(pasori_devname,O_RDWR);

        config = 1;
        i = ioctl(pp->fd_cntl,USB_SET_CONFIG,&config);
        pp->fd_intr = open(pasori_intr,O_RDONLY | O_NONBLOCK);
        if( (pp->fd_cntl < 0) || (pp->fd_intr < 0) ){
                Log("error opening pasori.%d %d",pp->fd_cntl,pp->fd_intr);
                close(pp->fd_cntl);
                close(pp->fd_intr);
                free(pp);
		return NULL;
        }
        return pp;
}

int pasori_send(pasori* pp,uint8 *cmd,uint8 size,int timeout){
        struct usb_ctl_request req;
        uint8 msg[128]; /* FIXME:max message bytes? */
        uint8 resp[256];
        signed int i;
	int t;

        req.ucr_request.bmRequestType = (2 << 5); /* VENDOR SPEC. */
        req.ucr_request.bRequest = 0;
        USETW(req.ucr_request.wLength,size);
        USETW(req.ucr_request.wValue,0);
        USETW(req.ucr_request.wIndex,0);
        req.ucr_data = cmd;
        req.ucr_flags = 0;
	
	t = timeout;
        i =ioctl(pp->fd_cntl,USB_SET_TIMEOUT,&t);
        if(i<0){
                Log("FIXME:SET TIMEOUT");
                return 1; /* FIXME:XXXXXXXXX */
        }
        i = ioctl(pp->fd_cntl,USB_DO_REQUEST,&req);

        if(i<0){
                Log("FIXME");
                return 1; /* FIXME:XXXXXXXXX */
        }

        Log("(SEND OK)");
        dbg_dump(cmd,size);
        /* FIXME:insert recv */
        Log("(ACK?   )");
        i = pasori_recv(pp,resp,255,timeout);
        dbg_dump(resp,i);

        return 0;
}

#define STATE_UNKNOWN 1
#define STATE_COMMAND 2
#define STATE_TIMEOUT 3

int pasori_recv(pasori* pp,uint8* buf,uint8 bufsize,int timeout){
        signed int i;
        int state;
        int size;
        int ptr;
        int one = 1;
	fd_set fds;
	struct timeval tv;
	
        uint8 resp;
        state = STATE_UNKNOWN;

        ptr = 0;
        do{
		FD_ZERO(&fds);
		FD_SET(pp->fd_intr,&fds);
		tv.tv_sec = 0;
		tv.tv_usec = timeout *1000; /* some select()s overwrites timeval */

		i = select(pp->fd_intr + 1,&fds,NULL,NULL,&tv);
		if( i < 0 ) { /* error in select () */
			/* FIXME: handle error */
			Log("FIXME:select().\n");
			state = STATE_TIMEOUT;
			size = ptr;
			break;
		}else if( i == 0 ) {
			/* FIXME: handle timeout */
			Log("Timeout.\n");
			state = STATE_TIMEOUT;
			size = ptr;
			break;
		}else {
		}

                i = read(pp->fd_intr,&resp,1);
                /* Log("READ   --  (%d)\n",i); */
                if(ptr == 3) { /* size */
                        if(resp == 0 || resp == 0xff) { /* ACK or NACK */
                                size = 6;
                        }else{
                                size = 7+resp;
                        }
                        state = STATE_COMMAND;
                }

                buf[ptr] = resp;
                /* debug */
                /* dbg_dump(&resp,1); */

                ptr++;

        }while((!(ptr==size)) || (!(state==STATE_COMMAND)));

	if(state != STATE_TIMEOUT){
		Log("(RECV OK)");
		dbg_dump(buf,size);
		return size+1;
	}else{
		Log("(TIMEOUT)");
		dbg_dump(buf,size);
		return 0;
	}
		
}

void pasori_close(pasori* p){
        close(p->fd_intr);
        close(p->fd_cntl);
}

