/* libpasori communicate LIBUSB ver. */

#include "libpasori_liblocal.h"
#include <usb.h>

#define PASORIUSB_VENDOR 0x054c
#define PASORIUSB_PRODUCT 0x01bb

void dbg_dump(unsigned char *b,unsigned int size){
	int i;
	if(size > 255) size = 255;
	for(i=0;i!=size;i++){
		Log("%02X ",b[i]);
	}
	Log("\n");
}

void pasori_close(pasori* pp){
	if(!pp) return;
	usb_release_interface(pp->dh,pp->dev->config->interface->altsetting->bInterfaceNumber);
	usb_close(pp->dh);
	free(pp);
}

pasori* pasori_open(char *p){ /* FIXME: unused arg. */
	struct usb_bus *bus;
	struct usb_device *dev;
	pasori *pp;
	pp = (pasori *)malloc(sizeof(pasori));
	usb_init();
#ifdef DEBUG
	usb_set_debug(255);
#else
	usb_set_debug(0);
#endif
	usb_find_busses();
	usb_find_devices();

	for(bus = usb_get_busses(); bus ; bus = bus->next){
		for(dev = bus->devices; dev ; dev = dev->next){
			Log("check for %04x:%04x\n",dev->descriptor.idVendor,dev->descriptor.idProduct); /* debug */
			if(dev->descriptor.idVendor == PASORIUSB_VENDOR &&
			   dev->descriptor.idProduct== PASORIUSB_PRODUCT){
				goto finish;
			}
		}
	}
	Log("pasori not found in USB BUS");
	return NULL;
finish:
	pp->dh = usb_open(dev);
	pp->dev= dev;
	
	if(usb_set_configuration(pp->dh,1)){
		/* error */
		pasori_close(pp);
		return NULL;
	}

	if(usb_claim_interface(pp->dh,pp->dev->config->interface->altsetting->bInterfaceNumber)){
		/* error */
		pasori_close(pp);
		return NULL;
	}
	return pp;
}

int pasori_send(pasori* pp,uint8* data,uint8 size,int timeout){ /* FIXME: ignore timeout */
	uint8 msg[256];
	uint8 resp[256];
	signed int i;
	Log("(send) send:");
	dbg_dump(data,size);
	i = usb_control_msg(pp->dh,USB_TYPE_VENDOR,0,0,0,data,size,400);
	i = usb_interrupt_read(pp->dh,0x81,resp,256,400);
	/* printf("i = %d",i); */ /* debug */
	if(i<0) return 1; /* FIXME:HANDLE INVALID RESPONSES */
	if(i!=6) return 1;
	if(resp[4] != 0xff) return 1;

	/* debug */
	Log("(ACK?) recv:");
	dbg_dump(resp,i);
	
	return 0;

}

int pasori_recv(pasori* pp,uint8* data,uint8 size,int timeout){
	signed int i;
	i = usb_interrupt_read(pp->dh,0x81,data,size,timeout);
	if(i>0){
		Log("(recv) recv:");
		dbg_dump(data,i); 
	}else{
		Log("(recv) ERROR\n");
	}
	return i;
}

