#include "StdAfx.h"
#include "MyApplication.h"

MyApplication::MyApplication(HWND hWnd) {
	directXFramework = new DirectXFramework(hWnd);
	LPDIRECT3DDEVICE9 pDevice = directXFramework->GetD3DDevice();
	skinMesh = new PmdSkinMesh(TEXT("reimu.pmd"), pDevice);
}

MyApplication::~MyApplication(void) {
	delete skinMesh;
	delete directXFramework;
}

void MyApplication::Run() {
	// Cg
	D3DLIGHT9 light = {D3DLIGHT_DIRECTIONAL, {1, 1, 1, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}};	// F
	light.Direction = D3DXVECTOR3(-1, -1, -1);		// 

	// J
	D3DXVECTOR3 eyePoint = D3DXVECTOR3(0.3f, 1.0f, 2.8f);	// _
	D3DXVECTOR3 lookAtPoint = D3DXVECTOR3(0, 1.0f, 0);		// _
	Camera camera(eyePoint, lookAtPoint);

	// `
	D3DXVECTOR3 position(0, 0, 0);	// ʒu
	D3DXMATRIX rotation;			// ]
	D3DXMatrixRotationY(&rotation, 0.01f*50 + D3DX_PI);
	skinMesh->AdvanceTime();
	directXFramework->BeginScene(240, 180, 180);// V[Jn
	skinMesh->Draw(&position, &rotation, &light, &camera);
	//skinMesh->DrawBoneObj(&position, &rotation, &light, camera);
	directXFramework->EndScene();	// V[I
}