#pragma once
#include "Mesh.h"

// uhdݕtbV̒_f[^
struct BlendVertex {
	D3DXVECTOR3 position;
	float weight[3];
	unsigned char matrixIndex[4];
	D3DXVECTOR3 normal;
	D3DXVECTOR2 texture;
};


// {[f[^
struct BoneInitData {
	bool visible;
	int firstChildIdx;	// 1q{[CfbNXBȂꍇ-1
	int siblingIdx;		// ̌Z{[CfbNXBȂꍇ-1
	D3DXMATRIX initMat;	// ps
	float length;		// \p{[̒
	BoneInitData() : firstChildIdx(-1), siblingIdx(-1), visible(true), length(0.1f) {}
};


// XLAj[VbVf[^BƎ`f[^͈x̍\̂Ɋi[B
struct SkinMeshInitData : public MeshData {
	vector<BlendVertex> blendVertices;
	vector<BoneInitData> boneInitData;
};


// {[
struct Bone {
	bool visible;			// \邩ۂ
	float length;			// \p{[̒
	int id;					// {[IDiʂԍj
	Bone* firstChild;		// 1q{[
	Bone* sibling;			// ̌Z{[
	D3DXMATRIX initMat;		// ps
	D3DXMATRIX offsetMat;	// {[ItZbgs
	D3DXMATRIX boneMat;		// {[ps
	D3DXMATRIX *combMatAry;	// pszւ̃|C^
	Bone() : id(), firstChild(), sibling(), combMatAry() {
		D3DXMatrixIdentity(&initMat);
		D3DXMatrixIdentity(&offsetMat);
		D3DXMatrixIdentity(&boneMat);
	}
};


/// XLAj[VbV
class SkinMesh : public Drawable3D {
protected:
	/// { ///
	int time;							// 
	SkinMesh(LPDIRECT3DDEVICE9 pDevice);// IuWFNg֎~
	LPDIRECT3DDEVICE9 pDevice;			// Direct3DfoCXIuWFNg
	/// bV ///
	LPD3DXMESH pMesh;					// bV
	vector<D3DMATERIAL9> materials;		// }eAz
	vector<LPDIRECT3DTEXTURE9> textures;// eNX`z
	vector<D3DXBONECOMBINATION> boneCombination;// {[Rrl[Vz
	virtual void CreateMesh(const SkinMeshInitData&);												// bV쐬
	virtual LPD3DXSKININFO CreateSkinInfo(const SkinMeshInitData& , const D3DVERTEXELEMENT9*);		// bV̂߂̃XL쐬
	virtual void DivideMesh(unsigned int numFace, LPD3DXMESH pOrgMesh, LPD3DXSKININFO pSkinInfo);	// uhspbg̃TCYzȂ悤ɃbV𕪊
	/// {[ ///
	vector<Bone> bones;					// {[\
	vector<D3DXMATRIX> combMat;			// ϊs
	vector<ID3DXMesh*> boneObj;			// \p{[
	virtual void CreateBoneMatrix(const SkinMeshInitData&);							// {[s, {[ItZbgs̍쐬
	virtual void ConvertInitMatrixInParent(Bone* me, D3DXMATRIX *parentoffsetMat);	// p[JWneWnɕϊċA֐
	virtual void CreateBoneObj(const SkinMeshInitData&);							// \p{[쐬
	virtual void ConvertBoneMatrixInWorld(Bone* me, D3DXMATRIX *parentWorldMat);	// {[s[hWnɕϊċA֐
	/// VF[_ ///
	D3DXHANDLE hTech, hWorld, hView, hProj, hAmbient, hDiffuse, hLightDir, hTexture;// nh
	LPD3DXEFFECT pFX;		// VF[_
	void CreateShader();	// VF[_̍쐬

	/// [V (bn[hR[fBO)
	virtual void UpdateBoneMatrix();

public:
	virtual ~SkinMesh();
	virtual void AdvanceTime();	// Ԃ߂
	virtual void Draw(D3DXVECTOR3* position, D3DXMATRIX* rotation, D3DLIGHT9* light, Camera* camera);		// `
	virtual void DrawBoneObj(D3DXVECTOR3* position, D3DXMATRIX* rotation, D3DLIGHT9* light, Camera* camera);// {[\
};


/// XLbVf[^
class HandMadeSkinMesh sealed : public SkinMesh {
	void CreateInitMat(D3DXMATRIX* initMat);
	void CreateSkinMeshData(SkinMeshInitData& skinMeshData);
public:
	HandMadeSkinMesh(LPDIRECT3DDEVICE9 pDevice);
};


/// PMDt@CǍ񂾃XLbV
class PmdSkinMesh sealed : public SkinMesh {
	const float scaleToDirectX;
	void CreateInitMat(const PmdStruct::PmdBone* pmdBone, unsigned int i, D3DXMATRIX* initMat, float* length);
	void CopyMaterial(D3DMATERIAL9& material, const PmdStruct::PmdMaterial& pmdMaterial);	// PmdMaterialD3DMATERIAL9Ƀf[^Rs[
public:
	PmdSkinMesh(LPCTSTR filename, LPDIRECT3DDEVICE9 pDevice);
};