----------------------------------------------------------------------
-- Premake4 configuration script for irrDrawstuff
-- Contributed by Kosei Demura
-- This script is modified the configuration script for Open Dynamics Engine
-- by Jason Perkins (starkos@industriousone.com)
-- For more information on Premake: http://industriousone.com/premake
----------------------------------------------------------------------

----------------------------------------------------------------------
-- Demo list: add/remove demos from here and the rest of the build
-- should just work.
----------------------------------------------------------------------

  local demos = {
    "amotor", "arm1", "arm2", "arm3", "bounce",
    "cube", "hello", "hopper", "hopper2", "hopper3",
    "legged", "monoBot", "omni", "pk", "sensor", "shapes",
    "slope", "trimesh", "warusap", "wheel1", "wheel2", "wheel4"
  }


----------------------------------------------------------------------
-- Configuration options
----------------------------------------------------------------------

  newoption {
    trigger     = "with-demos",
    description = "Builds the demo applications and irrDrawstuff library"
  }


  newoption {
    trigger = "to",
    value   = "path",
    description = "Set the output location for the generated project files"
  }

  -- always clean all of the optional components and toolsets
  if _ACTION == "clean" then
    _OPTIONS["with-demos"] = ""
    for action in pairs(premake.actions) do
      os.rmdir(action)
    end
  end



----------------------------------------------------------------------
-- The solution, and solution-wide settings
----------------------------------------------------------------------

  solution "irrdrawstuff"

    language "C++"
    location ( _OPTIONS["to"] or _ACTION )

    includedirs {
       "../include",
       "../src",
       "../../irrlicht-1.7.1/include",
       "../../ode-0.11.1/include",
    }

    defines {"dDOUBLE"}

    configuration { "Windows" }
       libdirs {
            "../../irrlicht-1.7.1/lib/Win32-gcc",
            "../../ode-0.11.1/lib/DebugDoubleLib"
        }

    configuration { "not Windows", "not MacOSX" }
        libdirs {
            "../../irrlicht-1.7.1/lib/Linux",
            "../../ode-0.11.1/lib/DebugDoubleLib"
        }


    -- define all the possible build configurations
    configurations {
      "DebugLib", "ReleaseLib"
    }

    configuration { "DebugLib" }
      defines { "_DEBUG" }
      flags   { "Symbols" }


    configuration { "ReleaseLib" }
      flags   { "OptimizeSpeed", "NoFramePointer" }

    configuration { "Windows" }
      defines { "WIN32" }

    configuration { "MacOSX" }
      linkoptions { "-framework Carbon" }

    -- give each configuration a unique output directory
    for _, name in ipairs(configurations()) do
      configuration { name }
        targetdir ( "../lib/" .. name )
    end

    -- disable Visual Studio security warnings
    configuration { "vs*" }
      defines { "_CRT_SECURE_NO_DEPRECATE" }

    -- don't remember why we had to do this
    configuration { "vs2002 or vs2003", "*Lib" }
      flags  { "StaticRuntime" }



----------------------------------------------------------------------
-- The demo projects, automated from list above. These go first so
-- they will be selected as the active project automatically in IDEs
----------------------------------------------------------------------

  if _OPTIONS["with-demos"] then
    for _, name in ipairs(demos) do

      project ( name )

        kind      "ConsoleApp"
        location  ( _OPTIONS["to"] or _ACTION )
        files     { "../irrdrawstuff/demo/" .. name .. ".*" }
     		links {  "irrdrawstuff", "Irrlicht" }

        --includedirs {
          --  "../include"
        --}

        --libdirs {
           --"../lib",
           -- "../../ode-0.11.1/lib/DebugDoubleLib"
        --}


        configuration { "Windows" }
            links   { "ode_doubled", "Irrlicht", "user32", "winmm","gdi32", "winspool", "comdlg32", "ole32", "oleaut32", "uuid",
            "odbc32", "odbccp32", "opengl32", "glu32" }

        configuration { "MacOSX" }
            linkoptions { "-framework Carbon -framework OpenGL -framework AGL" }


        configuration { "not Windows", "not MacOSX" }
            libdirs { "/usr/X11R6/lib"}
            links {  "ode_doubled", "Irrlicht", "GL", "Xxf86vm", "Xext", "X11" }

    end
  end



----------------------------------------------------------------------
-- The irrDrawstuff library project
----------------------------------------------------------------------

  project "irrdrawstuff"

    kind     "StaticLib"
    location ( _OPTIONS["to"] or _ACTION )

    files {
      "../include/*.h",
      "../irrdrawstuff/src/*.h",
      "../irrdrawstuff/src/*.cpp",
    }

    configuration { "windows" }
      links   { "user32" }

    configuration { "DebugLib" }
      kind    "StaticLib"
      targetname "irrdrawstuffd"
      defines    "dDOUBLE"

   configuration { "ReleaseLib" }
      kind    "StaticLib"
      targetname "irrdrawstuff"
      defines    "dDOUBLE"



