/*************************************************************************
 *                                                                       *
 * The irrDrawStuff Library                                              *
 *                                                                       *
 * All rights reserved.  Web: http://demura.net                          *
 *                                                                       *
 * This library is free software; you can redistribute it and/or         *
 * modify it under the terms of EITHER:                                  *
 *   (1) The GNU Lesser General Public License as published by the Free  *
 *       Software Foundation; either version 2.1 of the License, or (at  *
 *       your option) any later version. The text of the GNU Lesser      *
 *       General Public License is included with this library in the     *
 *       file LICENSE.TXT.                                               *
 *   (2) The BSD-style license that is included with this library in     *
 *       the file LICENSE-BSD.TXT.                                       *
 *                                                                       *
 * Created by: Kosei Demura, Kazuma Hosokawa                             *
 * Developed since: 2010-01-12                                           *
 *************************************************************************/

// This library is upper compatible with the drawstuff library of
// the Open Dynamics Engine (http://www.ode.org/). The drawstuff is based on
// the OpenGL library. This library, however, is based on the irrlicht engine
// (http://irrlicht.sourceforge.net/) which is an open source realtime 3D engine.

#ifndef __IRRSTUFF_H__
#define __IRRSTUFF_H__

#include <irrlicht.h>
#include <ode/ode.h>

#define irrlicht

#ifdef irrlicht
#define dsElapsedTime     diElapsedTime
#define dsFunctions       diFunctions
#define dsSimulationLoop  diSimulationLoop
#define dsSetColor        diSetColor
#define dsSetColorAlpha   diSetColorAlpha
//#define dsDrawLine        diDrawLine
#define dsDrawLineD       diDrawLineD
//#define dsDrawBox         diDrawBox
#define dsDrawBoxD        diDrawBoxD
#define dsDrawBox2D        diDrawBox2D
//#define dsDrawCapsule     diDrawCapsule
#define dsDrawCapsuleD    diDrawCapsuleD
#define dsDrawConvexD     diDrawConvexD
//#define dsDrawConvex      diDrawConvex
//#define dsDrawCylinder    diDrawCylinder
#define dsDrawCylinderD   diDrawCylinderD
//#define dsDrawTriangle    diDrawTriangle
#define dsDrawTriangleD   diDrawTriangleD
#define dsDrawSphereD     diDrawSphereD
#define dsDrawSphere2D    diDrawSphere2D
//#define dsDrawSphere      diDrawSphere
#define dsSetViewpoint    diSetViewpoint
#define dsGetViewpoint    diGetViewpoint
#define dsGetShadows      diGetShadows
#define dsSetShadows      diSetShadows
#define dsGetTextures     diGetTextures
#define dsSetTextures     diSetTextures
#define dsSetTexture      diSetTexture
#define dsPrintf          diPrintf
#define dsSetSphereQuality  diSetSphereQuality
#define dsSetCapsuleQuality diSetCapsuleQuality
#endif

using namespace irr;
using namespace core;
using namespace video;
using namespace scene;

#define DS_VERSION "0.0.4"
#define DEFAULT_FONT "../../media/font.bmp"
#define DEFAULT_PATH_TO_TEXTURES "../../media"

#ifndef SAFE_DELETE
#define SAFE_DELETE( x ) { delete ( x ); ( x ) = NULL; }
#endif
#ifndef SAFE_DELETE_ARRAY
#define SAFE_DELETE_ARRAY( x ) { delete[] ( x ); ( x ) = NULL; }
#endif

#ifndef M_PI
#define M_PI (3.14159265358979323846)
#endif

#define PI pi

#ifdef __cplusplus
extern "C" {
#endif

/* texture numbers */
enum DS_TEXTURE_NUMBER
{
    DS_NONE = 0,       /* uses the current color instead of a texture */
    DS_WOOD,
    DS_CHECKERED,
    DS_GROUND,
    DS_SKY,
};

typedef struct diFunctions
{
    // int version;                /* put DS_VERSION here */
    char *version;                /* put DS_VERSION here */
    /* version 1 data */
    void (*start)();              /* called before sim loop starts */
    void (*step) (int pause);     /* called before every frame */
    void (*command) (int cmd);    /* called if a command key is pressed */
    void (*stop)();               /* called after sim loop exits */
    /* version 2 data */
    char *path_to_textures;       /* if nonzero, path to texture files */
    /* new data */
    double sim_time_per_loop;    // simulation time per a loop
} diFunctions;

// プロトタイプ宣言
void diSetViewpoint(float xyz[3], float hpr[3]);
void diGetViewpoint(float xyz[3], float hpr[3]);
void diSimulationLoop(int argc, char **argv, int window_width,
                      int window_height, diFunctions *fn);
void diSetColor(float r, float g, float b);
void diSetColorAlpha(float r, float g, float b, float alpha);

void diDrawBox(const float pos[3], const float R[12], const float sides[3]);
void diDrawBoxD(const double pos[3], const double R[12], const double sides[3]);
void diDrawBox2D(const double pos[3], const double R[12], const double sides[3]);
void diDrawCapsule(const float pos[3], const float R[12],
                   float length, float radius);
void diDrawCapsuleD(const double pos[3], const double R[12],
                    float length, float radius);
void diDrawConvex(const float pos[3], const float R[12],
                   float *_planes,unsigned int _planecount,
                   float *_points,unsigned int _pointcount,unsigned int *_polygons);
void diDrawConvexD(const double pos[3], const double R[12],
                    double *_planes,unsigned int _planecount,
                    double *_points,unsigned int _pointcount, unsigned int *_polygons);
void diDrawCylinder(const float pos[3], const float R[12],
                    float length, float radius);
void diDrawCylinderD(const double pos[3], const double R[12],
                     float length, float radius);
void diDrawSphere(const float pos[3], const float R[12], float radius);
void diDrawSphereD(const double pos[3], const double R[12], double radius);
void diDrawSphere2(const float pos[3], const float R[12], float radius);
void diDrawSphere2D(const double pos[3], const double R[12], double radius);

bool BtnClicked(gui::IGUIButton* buton);

int  diGetShadows();
void diSetShadows(int a);
int  diGetTexture();
void diGetViewpoint(float xyz[3], float hpr[3]);
void diSetTexture(int a);


void diDrawString(char *, int ax, int ay, int bx, int by);
//void diDrawMesh(const float pos[3], const float R[12], char *file);
//void diDrawMeshD(const double pos[3], const double R[12], char *file);
void diDrawMesh(const dReal* pos, const dReal* R,
		float *vertices, int vertex_count, unsigned int *indices, int index_count, int solid);
void diDrawTriangle(const float pos[3], const float R[12],const float *v0, const float *v1,const float *v2, int solid);
void diDrawTriangleD(const double pos[3], const double R[12], const double *v0, const double *v1, const double *v2, int solid);

void diMotion(int mode, int deltax, int deltay);
void diDrawLine(const float pos1[3], const float pos2[3]);
void diDrawLineD(const double _pos1[3], const double _pos2[3]);
void diSetCapsuleQuality(int n);
void diSetSphereQuality(int n);
void dsStop();
double dsElapsedTime();

// New functions
void diPrintf(int y,int x, const char *text,...);
void diPrintw(int y,int x, const char *font,int color,const char*text,...);
void diLoadMesh(char *filename,char *texturename, float **vertices,int *vertexcount,
				dTriIndex **indices,int *indexcount,float *pos,float *scale);
void diLoadMesh2(char *filename);

#define isdigit irrisdigit
inline s32 irrisdigit(s32 c)
{
   return c >= '0' && c <= '9';
}

/* closing bracket for extern "C" */
#ifdef __cplusplus
}
#endif

#endif
