/* うさぎの表示 */
#include <ode/ode.h>
//#include <drawstuff/drawstuff.h>
#include <irrdrawstuff.h>
#include "texturepath.h"
#include "bunny_geom.h"


#ifdef _MSC_VER
#pragma warning(disable:4244 4305)  // for VC++, no precision loss complaints
#endif

// select correct drawing functions
#ifdef dDOUBLE
#define dsDrawBox dsDrawBoxD
#define dsDrawSphere dsDrawSphereD
#define dsDrawCylinder dsDrawCylinderD
#define dsDrawCapsule dsDrawCapsuleD
#define dsDrawLine dsDrawLineD
#define dsDrawTriangle dsDrawTriangleD
#endif

dsFunctions fn;
static void simLoop(int cmd);
double R[12];
static dWorldID world;
static dSpaceID space;

// 計測用
char data_file[]= "drawstuff_trimesh.csv";
static int get_fps = 0;

dGeomID TriMesh1;
dGeomID TriMesh2;
static dTriMeshDataID TriData1, TriData2;  // reusable static trimesh data

char locase (char c)
{
	if (c >= 'A' && c <= 'Z') return c - ('a'-'A');
	else return c;
}

static void command (int cmd)
{
	cmd = locase (cmd);

	if (cmd == 's') {
		get_fps = 1;
	}
}

// start simulation - set viewpoint
static void start()
{
	//  dAllocateODEDataForThread(dAllocateMaskAll);

	//  static float xyz[3] = {2.1640f,-1.3079f,1.7600f};
	//  static float hpr[3] = {125.5000f,-17.0000f,0.0000f};
	static float xyz[3] = {2.0f,-2.0f,1.0f};
	static float hpr[3] = {125.5000f,-17.0000f,0.0000f};
	dsSetViewpoint (xyz,hpr);
	dRSetIdentity(R);
}

void setDrawStuff()           /*** 描画関数の設定 ***/
{
	fn.version = DS_VERSION;    // ドロースタッフのバージョン
	fn.start   = &start;        // 前処理 start関数のポインタ
	fn.step    = &simLoop;      // simLoop関数のポインタ
	//  fn.path_to_textures = "../../drawstuff/textures"; // テクスチャ
	fn.path_to_textures = (char *) DRAWSTUFF_TEXTURE_PATH;
}

void dmLoop(int w, int h)
{
	setDrawStuff();
	dsSimulationLoop(1,0,w,h,&fn);
}

void put_data(int no,int fps)
{
	FILE *fp;
	if((fp = fopen(data_file,"a")) == NULL){
		printf("can not file open\n");
	}
	else{
		fprintf(fp,"%d\n",fps);
		fclose(fp);
	}

}

//void drawMesh(const dReal* pos, const dReal* R,  float Vertices[VertexCount * 3], int vertex_count,
//			  dTriIndex Indices[IndexCount / 3][3], int index_count, int solid )
void drawMesh(const dReal* pos, const dReal* R,  float *vertices, int vertex_count,
			  unsigned int *indices, int index_count, int solid )
{
	for (int i = 0; i < index_count / 3; i++){
		const dReal v[9] = { // explicit conversion from float to dReal
			vertices[indices[3*i] * 3 + 0],
			vertices[indices[3*i] * 3 + 1],
			vertices[indices[3*i] * 3 + 2],
			vertices[indices[3*i+1] * 3 + 0],
			vertices[indices[3*i+1] * 3 + 1],
			vertices[indices[3*i+1] * 3 + 2],
			vertices[indices[3*i+2] * 3 + 0],
			vertices[indices[3*i+2] * 3 + 1],
			vertices[indices[3*i+2] * 3 + 2]};
			dsDrawTriangle(pos, R, &v[0], &v[3], &v[6], solid);
	}
}

// simulation loop
static void simLoop (int pause)
{
	static double time_sum = 0.0;
	static int step_sum = 0;

	dsSetColor (1,0,0);
	// dsSetTexture(DS_WOOD);

	const dReal* pos = dGeomGetPosition(TriMesh1);
	const dReal* R   = dGeomGetRotation(TriMesh1);
	drawMesh(pos, R, Vertices, VertexCount, (unsigned int *) Indices, IndexCount, 0);

	const dReal* pos2 = dGeomGetPosition(TriMesh2);
	const dReal* R2   = dGeomGetRotation(TriMesh2);
	drawMesh(pos2, R2, Vertices, VertexCount, (unsigned int *) Indices, IndexCount, 1);

	//  描画速度の計測(FPS)
	if(get_fps){
		double dt = dsElapsedTime();
		time_sum += dt;
		step_sum++;
		if (time_sum >= 1.0){
			static int no = 1;
			printf("%d : FPS = %d\n",no,step_sum);
			put_data(no,step_sum);
			time_sum = 0.0;
			step_sum = 0;
			no++;
		}
	}
}

int main(int argc, char **argv)
{
	TriData1 = dGeomTriMeshDataCreate();
	dGeomTriMeshDataBuildSingle(TriData1, &Vertices[0], 3 * sizeof(float), VertexCount, (dTriIndex*)&Indices[0],		IndexCount, 3 * sizeof(dTriIndex));
	TriData2 = dGeomTriMeshDataCreate();
	dGeomTriMeshDataBuildSingle(TriData2, &Vertices[0], 3 * sizeof(float), VertexCount, (dTriIndex*)&Indices[0],		IndexCount, 3 * sizeof(dTriIndex));

	TriMesh1 = dCreateTriMesh(space, TriData1, 0, 0, 0);
	TriMesh2 = dCreateTriMesh(space, TriData2, 0, 0, 0);
	dGeomSetData(TriMesh1, TriData1);
	dGeomSetData(TriMesh2, TriData2);

	{dGeomSetPosition(TriMesh1, 0, 0, 0.9);
	dMatrix3 Rotation;
	dRFromAxisAndAngle(Rotation, 1, 0, 0, M_PI / 2);
	dGeomSetRotation(TriMesh1, Rotation);}

	{dGeomSetPosition(TriMesh2, 1, 0, 0.9);
	dMatrix3 Rotation;
	dRFromAxisAndAngle(Rotation, 1, 0, 0, M_PI / 2);
	dGeomSetRotation(TriMesh2, Rotation);}

	fn.command = &command;
	dmLoop(800, 600); // シミュレーションループ ウインドウの幅，高
	return 0;
}

