// Copyright (C) 2010 Kosei Demura
// This file is part of the irrDrawStuff library.
// Please read copyright notice in irrdrawstuff.h for conditions of distribution and usage. 
// 基本形状 (ボックス，球，円柱，カプセル)，空，地面，地面のマーカを描画するクラス

#ifndef __IDS_DRAW_PRIMITIVES_H
#define __IDS_DRAW_PRIMITIVES_H

#include "simLoop.h"
#include "sceneNode.h"

enum Primitive
{
	BOX, SPHERE, CAPSULE, CYLINDER, CONVEX, TRIANGLE, LINE, NONE
};

class Ground
{
public:
	Ground();
	~Ground();

	float red;    // ground color for when there's no texture
	float green;
	float blue;
	float scale;   // ground texture scale (1/size)
	float offsetX; // offset of ground texture (x axis)
	float offsetY; // offset of ground texture (y axis)
};

class DrawPrimitives
{
public:
	Ground *ground;

	DrawPrimitives(IVideoDriver *driver, ISceneManager *smgr, irr::gui::IGUIEnvironment *env);
	~DrawPrimitives();

	void drawSky(float view_xyz3[3]);
	void drawGround();
	void drawPyramidGrid();

	void setSphereQuality(int n);
	void setCapsuleQuality(int n);

	void drawBox(const double pos[3], const double R[12],const double sides[3]);
	void drawBox2(const double pos[3], const double R[12],const double sides[3]); // 新しい関数
	void drawSphere(const double pos[3], const double R[12], double radius);
	void drawSphere2(const double pos[3], const double R[12], double radius); // 新しい関数
	void drawCylinder(const double pos[3], const double R[12], float length, float radius);
	void drawCylinder2(const double pos[3], const double R[12],  float length, float radius);
	void drawCapsule(const double pos[3], const double R[12], float length, float radius);
	void drawCapsule2(const double pos[3], const double R[12], float length, float radius);

	void drawConvex(const double pos[3], const double R[12],  double *_planes,
				unsigned int _planecount, double *_points,   unsigned int _pointcount,  unsigned int *_polygons);
	void drawTriangle(const double pos[3], const double R[12], const double *v0, 
								const double *v1, const double *v2, int solid);
	void drawTriangle2(const double pos[3], const double R[12], const double *v0, 
								const double *v1, const double *v2, int solid);
	void setColor(float red, float green, float blue, float alpha);
	void setTextureNum(int a);
	void setTexturePath(char *p);


	float getRed(), getGreen(), getBlue(), getAlpha();
	void drawLine(const double pos1[3], const double pos2[3]);
	irr::gui::IGUIEnvironment *getEnv();
	void resetLastDraw();

private:
	irr::video::IVideoDriver *idriver;
	irr::scene::ISceneManager *ismgr;
	irr::gui::IGUIEnvironment *ienv;
	char *iprefix; // Texture prefix path
	int capped_cylinder_quality;
	int sphere_quality;
	float shadowIntensity;
	int tnum;         // current texture number
	float red, green, blue, alpha;
	SColor color;
	static const int objectNum = 100;
	Primitive last_draw; // 最後に描画された基本図形

	irr::scene::ISceneNode *boxNode[objectNum];
	irr::scene::ISceneNode *sphereNode[objectNum];

	//scene::IAnimatedMeshSceneNode *sphereNode[objectNum];
	//scene::IAnimatedMesh *sphereMesh[objectNum];

	idsCapsuleSceneNode  *myCapsuleNode[objectNum];  // custom scene node
	idsCylinderSceneNode *myCylinderNode[objectNum]; // custom scene node
	idsBoxSceneNode      *myBoxNode[objectNum];      // custom scene node

	//scene::ISceneNode *cylinderNode;
	//scene::ISceneNode *capsuleNode;
	irr::video::ITexture *boxTexture[objectNum];  //Texture for boxes
	irr::video::ITexture *sphereTexture[objectNum];  //Texture for spheres
	irr::video::ITexture *capsuleTexture[objectNum];  //Texture for capsule
	irr::video::ITexture *cylinderTexture[objectNum];  //Texture for cylinder

	irr::video::ITexture *wood_texture;
	irr::video::ITexture *ground_texture;
	irr::video::ITexture *sky_texture;
	irr::video::ITexture *checkered_texture;
	
	
	void setColor(SMaterial *material);
	void setColor(ISceneNode *node, float r, float g, float b, float alpha);
	void setTexture(Primitive pri_num, SMaterial *material);
	void setTexture(Primitive pri_num, int num, scene::ISceneNode *node, video::ITexture *nodeTexture);

	void setShadowDrawingMode(SColor *color);
	void drawBoxShadow(const double pos[3], const double R[12], const double sides[3]);	
	void drawCapsuleShadow(const double pos[3], const double R[12], double length, double radius);
	void drawSphereShadow (float px, float py, float pz, float radius);
	void drawCylinderShadow(const double pos[3], const double R[12],float l, float r);
	void drawPatch(float pos[3],float R[12],float radius,float p1[3], float p2[3], float p3[3], int level);
	void drawPatch2(float p1[3], float p2[3], float p3[3], int level);

	void drawConvexInside(double *_planes,unsigned int _planecount,
                         double *_points, unsigned int _pointcount,  unsigned int *_polygons);
	void drawCapsuleMesh(float length, float radius);
	IMesh* createCylinderMesh2(f32 radius, f32 length, u32 tesselation, const video::SColor& color, 
			bool closeTop, f32 oblique) const;
};

#endif

