/*************************************************************************
 *                                                                       *
 * The irrDrawStuff Library                                              *
 *                                                                       *
 * All rights reserved.  Web: http://demura.net                          *
 *                                                                       *
 * This library is free software; you can redistribute it and/or         *
 * modify it under the terms of EITHER:                                  *
 *   (1) The GNU Lesser General Public License as published by the Free  *
 *       Software Foundation; either version 2.1 of the License, or (at  *
 *       your option) any later version. The text of the GNU Lesser      *
 *       General Public License is included with this library in the     *
 *       file LICENSE.TXT.                                               *
 *   (2) The BSD-style license that is included with this library in     *
 *       the file LICENSE-BSD.TXT.                                       *
 *                                                                       *
 * Created by: Kosei Demura, Kazuma Hosokawa                             *
 * Developed since: 2010-01-12                                           *
 *************************************************************************/

// This library is upper compatible with the drawstuff library of
// the Open Dynamics Engine (http://www.ode.org/). The drawstuff is based on
// the OpenGL library. This library, however, is based on the irrlicht engine
// (http://irrlicht.sourceforge.net/) which is an open source realtime 3D engine.

// このライブラリはOpen Dynamics Engine　付属のdrawstuffの上位互換ライブラリです．
// drawstuffのソースコードをirrlichtのAPIを使いC++言語に書き直したものです．

#include "simLoop.h"

// irrDrawStuffの始まり
extern "C" void diSimulationLoop(int argc, char **argv, int window_width,
                      int window_height, diFunctions *fn)
{
	SimLoop *sim = SimLoop::getInstance();
	sim->init();

	assert(!sim->getCurrentState() && "diSimulationLoop() called more than once");

	int initial_pause = 0;
    sim->setCurrentState(1);

    sim->diPlatformSimLoop(window_width,window_height,fn,initial_pause);
    sim->setCurrentState(0);
}
