// Copyright (C) 2010 Kosei Demura
// This file is part of the irrDrawStuff library.
// Please read copyright notice in irrdrawstuff.h for conditions of distribution and usage. 
// 今まで分類されていないその他の関数を集めたクラス

#ifndef __IDS_NONPLATFORM_H
#define __IDS_NONPLATFORM_H

#include "simLoop.h"

class Misc
{
public:
	void loadModel(const c8* fn);	
	void makeTexture(char *file_name, float r, float g, float b);
	void updateForDraw(scene::ISceneNode* irrSceneNode, const double pos[3], const double R[12]);
	void normalizeVector3(float v[3]);
	void dsToiDS(const double ode_pos[3], const double ode_R[12], double pos[3], vector3df *Rot);
	void odeToIrrRotation(const double R[12]);
	void odeToIrrTransform(const double pos[3],const double R[12]);
	void odeToIrrTransform(const double pos[3],const double R[12], float size);
	void setShadowTransform();
	matrix4 setTransform(const float pos[3], const float R[12]);

	Misc(IVideoDriver *driver, IrrlichtDevice *device);
	~Misc();
private:
	IVideoDriver *idriver;
	IrrlichtDevice *idevice;
};
#endif
