﻿/*
*Copyright(c) Live2D Inc. All rights reserved.
*このソースコードの使用には、"http://www.live2d.com/eula/live2d-open-software-license-agreement_jp.html"ファイルにあるLive2D Open Software ライセンスが適用されます。
*Use of this source code is governed by a Live2D Open Software license that can be found in the "http://www.live2d.com/eula/live2d-open-software-license-agreement_en.html" file.
*/

using System.Collections.Generic;
using UnityEngine;
using live2d.Euclid;

[RequireComponent(typeof(Camera))]
public class EuclidCamera : MonoBehaviour
{
    [SerializeField]
    private List<EuclidModel> TargetEuclidModel = new List<EuclidModel>();

    private EuclidCameraBackend backend = new EuclidCameraBackend(false);

    public void AddEuclidModel(EuclidModel model)
    {
        if (TargetEuclidModel.Contains(model) || model == null) { return; }
        TargetEuclidModel.Add(model);
        var modelBackend = registerEuclidModel(model);
        backend.InitializeModel(this.transform, modelBackend);
    }

    private EuclidModelBackend registerEuclidModel(EuclidModel model)
    {
        if (model == null) { return null; }

        var modelBackend = model.AddBackend();
        backend.registerEuclidModel(modelBackend);

        return modelBackend;
    }

    #region Unity Functions
    private void Awake()
    {
        foreach (var m in TargetEuclidModel)
        {
            registerEuclidModel(m);
        }
    }

    private void OnEnable()
    {
        backend.InitializeModel(this.transform);
    }

    private void Update()
    {
        // カメラや3Dモデルの情報からEuclidモデルの向きに関するパラメータを更新する
        backend.UpdateEuclidModelParameter(transform.position);
    }

    private void LateUpdate()
    {
        // カメラや3Dモデルの情報からEuclidモデルの向きに関するパラメータを更新する
        backend.LateUpdateEuclidModelParameter(transform.position);
    }

    private void OnDisable()
    {
        backend.Close();
    }

    private void OnDestroy()
    {
        backend.Destroy();
    }
    #endregion
}
