﻿/*
*Copyright(c) Live2D Inc. All rights reserved.
*このソースコードの使用には、"http://www.live2d.com/eula/live2d-open-software-license-agreement_jp.html"ファイルにあるLive2D Open Software ライセンスが適用されます。
*Use of this source code is governed by a Live2D Open Software license that can be found in the "http://www.live2d.com/eula/live2d-open-software-license-agreement_en.html" file.
*/

using System.Linq;
using UnityEngine;

namespace live2d.Mecanim.EditorExtensions
{
    public sealed class FrameByFrameSampler
    {
        public Keyframe[] SampleFrames(float[] frames, float fps)
        {
            return frames
                .Select((f, i) => new Keyframe(i/fps, f))
                .ToArray();
        }
    }
}