﻿/*
*Copyright(c) Live2D Inc. All rights reserved.
*このソースコードの使用には、"http://www.live2d.com/eula/live2d-open-software-license-agreement_jp.html"ファイルにあるLive2D Open Software ライセンスが適用されます。
*Use of this source code is governed by a Live2D Open Software license that can be found in the "http://www.live2d.com/eula/live2d-open-software-license-agreement_en.html" file.
*/

namespace live2d.Mecanim.EditorExtensions
{
    /// <summary>
    ///     Contains frame-by-frame information on a mtn parameters curve.
    /// </summary>
    public struct MtnParameterCurve
    {
        public readonly string ParameterName;

        public readonly float[] Values;

        public int DurationInFrames
        {
            get
            {
                return Values == null ? 0 : Values.Length;
            }
        }

        #region Constructors

        internal MtnParameterCurve(string parameterName, float[] values)
        {
            ParameterName = parameterName;
            Values = values;
        }

        #endregion
    }
}