﻿/*
*Copyright(c) Live2D Inc. All rights reserved.
*このソースコードの使用には、"http://www.live2d.com/eula/live2d-open-software-license-agreement_jp.html"ファイルにあるLive2D Open Software ライセンスが適用されます。
*Use of this source code is governed by a Live2D Open Software license that can be found in the "http://www.live2d.com/eula/live2d-open-software-license-agreement_en.html" file.
*/

using System.Text;
using ParameterInfo = live2d.Euclid.ParameterInfo;

namespace live2d.Mecanim.EditorExtensions
{
    internal sealed class ParametersScriptGenerator
    {
        private string _className;

        private ParameterInfo[] _parametersInfo;

        #region Setters

        public ParametersScriptGenerator SetClassName(string className)
        {
            _className = className;


            return this;
        }

        public ParametersScriptGenerator SetParametersInfo(ParameterInfo[] parametersInfo)
        {
            _parametersInfo = parametersInfo;


            return this;
        }

        #endregion

        public string GenerateCode()
        {
            var codeBuilder = new StringBuilder();


            // Prepare data.
            var baseClass = "ModelParameters";
            var className = _className;
            var parameters = _parametersInfo;


            // Generate using directives.
            codeBuilder.AppendLine("using live2d.Mecanim;");
            codeBuilder.AppendLine("using UnityEngine;");
            codeBuilder.AppendLine();
            codeBuilder.AppendLine();


            // "Open" class.
            codeBuilder.AppendLine("public class " + className + " : " + baseClass);
            codeBuilder.AppendLine("{");


            // Generate parameter fields.
            foreach (var parameter in parameters)
            {
                var name = parameter.Name;

                if (name.StartsWith("PARAM_JOINT_"))
                {
                    continue;
                }

                //とりあえずこいつをいれとかないとね。.は禁止文字にしたいですねぇ
                if (name.Contains("."))
                {
                    name = name.Replace(".", "");
                }



                var defaultValue = Beautify(parameter.DefaultValue);
                var minimumValue = Beautify(parameter.MinimumValue);
                var maximumValue = Beautify(parameter.MaximumValue);


                codeBuilder.AppendLine("\t[Range(" + minimumValue + ", " + maximumValue + ")]");
                codeBuilder.AppendLine("\tpublic float " + name + " = " + defaultValue + ";");
                codeBuilder.AppendLine("\t");
            }

            codeBuilder.AppendLine("\t");


            // Generate update method.
            codeBuilder.AppendLine("\tprivate void Update()");
            codeBuilder.AppendLine("\t{");


            foreach (var parameter in parameters)
            {
                var name = parameter.Name;

                if (name.StartsWith("PARAM_JOINT_"))
                {
                    continue;
                }

                //とりあえずこいつをいれとかないと動かない
                if (name.Contains("."))
                {
                    name = name.Replace(".", "");
                }
                codeBuilder.AppendLine("\t\tSetAt(\"" + parameter.Name + "\", " + name + ");");
            }

            codeBuilder.AppendLine("\t}");


            // "Close" class.
            codeBuilder.AppendLine("}");


            return codeBuilder.ToString();
        }

        #region Helper methods

        private static string Beautify(float value)
        {
            var format = value >= 0.0f && value < 1.0f ? "{0:0.0######f}" : "{0:.0######f}";


            return string.Format(format, value);
        }

        #endregion
    }
}
