/*
*Copyright(c) Live2D Inc. All rights reserved.
*このソースコードの使用には、"http://www.live2d.com/eula/live2d-open-software-license-agreement_jp.html"ファイルにあるLive2D Open Software ライセンスが適用されます。
*Use of this source code is governed by a Live2D Open Software license that can be found in the "http://www.live2d.com/eula/live2d-open-software-license-agreement_en.html" file.
*/

#ifndef EUCLID_SDK_SHADER_INCLUDED
#define EUCLID_SDK_SHADER_INCLUDED

#include "UnityCG.cginc"

#if defined(UNITY_SINGLE_PASS_STEREO)
#	define EUCLID_VR_USE_PREDEFINED_EYE_INDEX
#elif UNITY_VERSION < 560
#	define EUCLID_VR_USE_ONPRERENDER_INDEX
#else
#	if defined(UNITY_STEREO_MULTIVIEW_ENABLED)
#		define EUCLID_VR_USE_PREDEFINED_EYE_INDEX
#	else
#		define EUCLID_VR_USE_ONPRERENDER_INDEX
#	endif
#endif

#if !defined(EUCLID_NO_VR_SUPPORT)

int euclid_RightEye;

#if defined(EUCLID_VR_USE_PREDEFINED_EYE_INDEX)
#	define euclid_StereoEyeIndex unity_StereoEyeIndex
#elif defined(EUCLID_VR_USE_ONPRERENDER_INDEX)
#	define euclid_StereoEyeIndex euclid_RenderingEye
CBUFFER_START(EuclidStereoRenderingEye)
	int euclid_RenderingEye = 0;
CBUFFER_END
#endif

inline fixed euclid_RenderingFactor()
{
	return 1 - abs(euclid_StereoEyeIndex - euclid_RightEye);
}

inline float4 EuclidMeshTransform(float4 pos)
{
	return pos * euclid_RenderingFactor();
}

inline float3 EuclidMeshTransform(float3 pos)
{
	return pos * euclid_RenderingFactor();
}

#else // EUCLID_NO_VR_SUPPORT
#	define EuclidMeshTransform(pos) pos
#endif

#endif
