﻿/*
*Copyright(c) Live2D Inc. All rights reserved.
*このソースコードの使用には、"http://www.live2d.com/eula/live2d-open-software-license-agreement_jp.html"ファイルにあるLive2D Open Software ライセンスが適用されます。
*Use of this source code is governed by a Live2D Open Software license that can be found in the "http://www.live2d.com/eula/live2d-open-software-license-agreement_en.html" file.
*/
Shader "Euclid/EuclidClippingMaskShader"
{
	Properties{
		_MainTex("Base (RGB)", 2D) = "white" {}

		_AlphaThreshold("Alpha Threshold", float) = 0.001
		_StencilRef1("StencilRef1", int) = 1
	}
	SubShader{
		Tags {
			"Queue" = "Transparent"
			"IgnoreProjector" = "True"
			"RenderType" = "Transparent"
			"PreviewType" = "Plane"
		}

		Cull Off
		Blend Off
		ZWrite Off
		Lighting Off
		ColorMask 0

		Pass{
			Stencil{
				Ref [_StencilRef1]
				Comp Equal
				Pass IncrWrap
			}

			CGPROGRAM

			#pragma vertex vert
			#pragma fragment frag

			#include "UnityCG.cginc"
			#include "EuclidCG.cginc"

			struct v2f {
				float4 pos : SV_POSITION;
				float2 uv : TEXCOORD0;
			};

			sampler2D _MainTex;
			float4 _MainTex_ST;
			float _AlphaThreshold;

			v2f vert(appdata_base v)
			{
				v2f o;
				o.pos = UnityObjectToClipPos(v.vertex);
				o.pos = EuclidMeshTransform(o.pos);
				o.uv = TRANSFORM_TEX(v.texcoord, _MainTex);
				return o;
			}

			fixed4 frag(v2f i) : SV_TARGET
			{
				fixed4 texcol = tex2D(_MainTex, i.uv);
				if (texcol.a <= _AlphaThreshold) discard;
				return 1;
			}

			ENDCG
		}
	}

	Fallback "VertexLit"
}
