﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/apigateway/APIGateway_EXPORTS.h>
#include <aws/apigateway/APIGatewayRequest.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/Array.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Http
{
    class URI;
} //namespace Http
namespace APIGateway
{
namespace Model
{

  /**
   * <p>A POST request to import an API to Amazon API Gateway using an input of an
   * API definition file.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/apigateway-2015-07-09/ImportRestApiRequest">AWS
   * API Reference</a></p>
   */
  class AWS_APIGATEWAY_API ImportRestApiRequest : public StreamingAPIGatewayRequest
  {
  public:
    ImportRestApiRequest();
    void AddQueryStringParameters(Aws::Http::URI& uri) const override;


    /**
     * <p>A query parameter to indicate whether to rollback the API creation
     * (<code>true</code>) or not (<code>false</code>) when a warning is encountered.
     * The default value is <code>false</code>.</p>
     */
    inline bool GetFailOnWarnings() const{ return m_failOnWarnings; }

    /**
     * <p>A query parameter to indicate whether to rollback the API creation
     * (<code>true</code>) or not (<code>false</code>) when a warning is encountered.
     * The default value is <code>false</code>.</p>
     */
    inline void SetFailOnWarnings(bool value) { m_failOnWarningsHasBeenSet = true; m_failOnWarnings = value; }

    /**
     * <p>A query parameter to indicate whether to rollback the API creation
     * (<code>true</code>) or not (<code>false</code>) when a warning is encountered.
     * The default value is <code>false</code>.</p>
     */
    inline ImportRestApiRequest& WithFailOnWarnings(bool value) { SetFailOnWarnings(value); return *this;}


    /**
     * <p>Custom header parameters as part of the request. For example, to exclude
     * <a>DocumentationParts</a> from an imported API, set
     * <code>ignore=documentation</code> as a <code>parameters</code> value, as in the
     * AWS CLI command of <code>aws apigateway import-rest-api --parameters
     * ignore=documentation --body 'file:///path/to/imported-api-body.json</code>.</p>
     */
    inline const Aws::Map<Aws::String, Aws::String>& GetParameters() const{ return m_parameters; }

    /**
     * <p>Custom header parameters as part of the request. For example, to exclude
     * <a>DocumentationParts</a> from an imported API, set
     * <code>ignore=documentation</code> as a <code>parameters</code> value, as in the
     * AWS CLI command of <code>aws apigateway import-rest-api --parameters
     * ignore=documentation --body 'file:///path/to/imported-api-body.json</code>.</p>
     */
    inline void SetParameters(const Aws::Map<Aws::String, Aws::String>& value) { m_parametersHasBeenSet = true; m_parameters = value; }

    /**
     * <p>Custom header parameters as part of the request. For example, to exclude
     * <a>DocumentationParts</a> from an imported API, set
     * <code>ignore=documentation</code> as a <code>parameters</code> value, as in the
     * AWS CLI command of <code>aws apigateway import-rest-api --parameters
     * ignore=documentation --body 'file:///path/to/imported-api-body.json</code>.</p>
     */
    inline void SetParameters(Aws::Map<Aws::String, Aws::String>&& value) { m_parametersHasBeenSet = true; m_parameters = std::move(value); }

    /**
     * <p>Custom header parameters as part of the request. For example, to exclude
     * <a>DocumentationParts</a> from an imported API, set
     * <code>ignore=documentation</code> as a <code>parameters</code> value, as in the
     * AWS CLI command of <code>aws apigateway import-rest-api --parameters
     * ignore=documentation --body 'file:///path/to/imported-api-body.json</code>.</p>
     */
    inline ImportRestApiRequest& WithParameters(const Aws::Map<Aws::String, Aws::String>& value) { SetParameters(value); return *this;}

    /**
     * <p>Custom header parameters as part of the request. For example, to exclude
     * <a>DocumentationParts</a> from an imported API, set
     * <code>ignore=documentation</code> as a <code>parameters</code> value, as in the
     * AWS CLI command of <code>aws apigateway import-rest-api --parameters
     * ignore=documentation --body 'file:///path/to/imported-api-body.json</code>.</p>
     */
    inline ImportRestApiRequest& WithParameters(Aws::Map<Aws::String, Aws::String>&& value) { SetParameters(std::move(value)); return *this;}

    /**
     * <p>Custom header parameters as part of the request. For example, to exclude
     * <a>DocumentationParts</a> from an imported API, set
     * <code>ignore=documentation</code> as a <code>parameters</code> value, as in the
     * AWS CLI command of <code>aws apigateway import-rest-api --parameters
     * ignore=documentation --body 'file:///path/to/imported-api-body.json</code>.</p>
     */
    inline ImportRestApiRequest& AddParameters(const Aws::String& key, const Aws::String& value) { m_parametersHasBeenSet = true; m_parameters.emplace(key, value); return *this; }

    /**
     * <p>Custom header parameters as part of the request. For example, to exclude
     * <a>DocumentationParts</a> from an imported API, set
     * <code>ignore=documentation</code> as a <code>parameters</code> value, as in the
     * AWS CLI command of <code>aws apigateway import-rest-api --parameters
     * ignore=documentation --body 'file:///path/to/imported-api-body.json</code>.</p>
     */
    inline ImportRestApiRequest& AddParameters(Aws::String&& key, const Aws::String& value) { m_parametersHasBeenSet = true; m_parameters.emplace(std::move(key), value); return *this; }

    /**
     * <p>Custom header parameters as part of the request. For example, to exclude
     * <a>DocumentationParts</a> from an imported API, set
     * <code>ignore=documentation</code> as a <code>parameters</code> value, as in the
     * AWS CLI command of <code>aws apigateway import-rest-api --parameters
     * ignore=documentation --body 'file:///path/to/imported-api-body.json</code>.</p>
     */
    inline ImportRestApiRequest& AddParameters(const Aws::String& key, Aws::String&& value) { m_parametersHasBeenSet = true; m_parameters.emplace(key, std::move(value)); return *this; }

    /**
     * <p>Custom header parameters as part of the request. For example, to exclude
     * <a>DocumentationParts</a> from an imported API, set
     * <code>ignore=documentation</code> as a <code>parameters</code> value, as in the
     * AWS CLI command of <code>aws apigateway import-rest-api --parameters
     * ignore=documentation --body 'file:///path/to/imported-api-body.json</code>.</p>
     */
    inline ImportRestApiRequest& AddParameters(Aws::String&& key, Aws::String&& value) { m_parametersHasBeenSet = true; m_parameters.emplace(std::move(key), std::move(value)); return *this; }

    /**
     * <p>Custom header parameters as part of the request. For example, to exclude
     * <a>DocumentationParts</a> from an imported API, set
     * <code>ignore=documentation</code> as a <code>parameters</code> value, as in the
     * AWS CLI command of <code>aws apigateway import-rest-api --parameters
     * ignore=documentation --body 'file:///path/to/imported-api-body.json</code>.</p>
     */
    inline ImportRestApiRequest& AddParameters(const char* key, Aws::String&& value) { m_parametersHasBeenSet = true; m_parameters.emplace(key, std::move(value)); return *this; }

    /**
     * <p>Custom header parameters as part of the request. For example, to exclude
     * <a>DocumentationParts</a> from an imported API, set
     * <code>ignore=documentation</code> as a <code>parameters</code> value, as in the
     * AWS CLI command of <code>aws apigateway import-rest-api --parameters
     * ignore=documentation --body 'file:///path/to/imported-api-body.json</code>.</p>
     */
    inline ImportRestApiRequest& AddParameters(Aws::String&& key, const char* value) { m_parametersHasBeenSet = true; m_parameters.emplace(std::move(key), value); return *this; }

    /**
     * <p>Custom header parameters as part of the request. For example, to exclude
     * <a>DocumentationParts</a> from an imported API, set
     * <code>ignore=documentation</code> as a <code>parameters</code> value, as in the
     * AWS CLI command of <code>aws apigateway import-rest-api --parameters
     * ignore=documentation --body 'file:///path/to/imported-api-body.json</code>.</p>
     */
    inline ImportRestApiRequest& AddParameters(const char* key, const char* value) { m_parametersHasBeenSet = true; m_parameters.emplace(key, value); return *this; }

  private:

    bool m_failOnWarnings;
    bool m_failOnWarningsHasBeenSet;

    Aws::Map<Aws::String, Aws::String> m_parameters;
    bool m_parametersHasBeenSet;

  };

} // namespace Model
} // namespace APIGateway
} // namespace Aws
