/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.app.Dialog;
import android.content.Context;
import android.os.Handler;
import android.text.Editable;
import android.text.InputFilter;
import android.text.method.ArrowKeyMovementMethod;
import android.text.method.MovementMethod;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.backends.android.AndroidInput;

class AndroidOnscreenKeyboard
implements View.OnKeyListener,
View.OnTouchListener {
    final Context context;
    final Handler handler;
    final AndroidInput input;
    Dialog dialog;
    TextView textView;

    public AndroidOnscreenKeyboard(Context context, Handler handler, AndroidInput input) {
        this.context = context;
        this.handler = handler;
        this.input = input;
    }

    Dialog createDialog() {
        this.textView = AndroidOnscreenKeyboard.createView(this.context);
        this.textView.setOnKeyListener((View.OnKeyListener)this);
        FrameLayout.LayoutParams textBoxLayoutParams = new FrameLayout.LayoutParams(-1, -2, 80);
        this.textView.setLayoutParams((ViewGroup.LayoutParams)textBoxLayoutParams);
        this.textView.setFocusable(true);
        this.textView.setFocusableInTouchMode(true);
        this.textView.setImeOptions(this.textView.getImeOptions() | 0x10000000);
        FrameLayout layout = new FrameLayout(this.context);
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, 0);
        layout.setLayoutParams(layoutParams);
        layout.addView((View)this.textView);
        layout.setOnTouchListener((View.OnTouchListener)this);
        this.dialog = new Dialog(this.context, 0x1030011);
        this.dialog.setContentView((View)layout);
        return this.dialog;
    }

    public static TextView createView(Context context) {
        TextView view = new TextView(context){
            Editable editable = new PassThroughEditable();

            protected boolean getDefaultEditable() {
                return true;
            }

            public Editable getEditableText() {
                return this.editable;
            }

            protected MovementMethod getDefaultMovementMethod() {
                return ArrowKeyMovementMethod.getInstance();
            }

            public boolean onKeyDown(int keyCode, KeyEvent event) {
                Log.d((String)"Test", (String)("down keycode: " + event.getKeyCode()));
                return super.onKeyDown(keyCode, event);
            }

            public boolean onKeyUp(int keyCode, KeyEvent event) {
                Log.d((String)"Test", (String)("up keycode: " + event.getKeyCode()));
                return super.onKeyUp(keyCode, event);
            }
        };
        return view;
    }

    public void setVisible(boolean visible) {
        if (visible && this.dialog != null) {
            this.dialog.dismiss();
            this.dialog = null;
        }
        if (visible && this.dialog == null && !this.input.isPeripheralAvailable(Input.Peripheral.HardwareKeyboard)) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    AndroidOnscreenKeyboard.this.dialog = AndroidOnscreenKeyboard.this.createDialog();
                    AndroidOnscreenKeyboard.this.dialog.show();
                    AndroidOnscreenKeyboard.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            AndroidOnscreenKeyboard.this.dialog.getWindow().setSoftInputMode(32);
                            InputMethodManager input = (InputMethodManager)AndroidOnscreenKeyboard.this.context.getSystemService("input_method");
                            if (input != null) {
                                input.showSoftInput((View)AndroidOnscreenKeyboard.this.textView, 2);
                            }
                        }
                    });
                    final View content = AndroidOnscreenKeyboard.this.dialog.getWindow().findViewById(0x1020002);
                    content.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){
                        int[] screenloc = new int[2];
                        private int keyboardHeight;
                        private boolean keyboardShowing;

                        public boolean onPreDraw() {
                            content.getLocationOnScreen(this.screenloc);
                            this.keyboardHeight = Math.abs(this.screenloc[1]);
                            if (this.keyboardHeight > 0) {
                                this.keyboardShowing = true;
                            }
                            if (this.keyboardHeight == 0 && this.keyboardShowing) {
                                AndroidOnscreenKeyboard.this.dialog.dismiss();
                                AndroidOnscreenKeyboard.this.dialog = null;
                            }
                            return true;
                        }
                    });
                }
            });
        } else if (!visible && this.dialog != null) {
            this.dialog.dismiss();
        }
    }

    public boolean onTouch(View view, MotionEvent e) {
        return false;
    }

    public boolean onKey(View view, int keycode, KeyEvent e) {
        return false;
    }

    public static class PassThroughEditable
    implements Editable {
        public char charAt(int index) {
            Log.d((String)"Editable", (String)"charAt");
            return '\u0000';
        }

        public int length() {
            Log.d((String)"Editable", (String)"length");
            return 0;
        }

        public CharSequence subSequence(int start, int end) {
            Log.d((String)"Editable", (String)"subSequence");
            return null;
        }

        public void getChars(int start, int end, char[] dest, int destoff) {
            Log.d((String)"Editable", (String)"getChars");
        }

        public void removeSpan(Object what) {
            Log.d((String)"Editable", (String)"removeSpan");
        }

        public void setSpan(Object what, int start, int end, int flags) {
            Log.d((String)"Editable", (String)"setSpan");
        }

        public int getSpanEnd(Object tag) {
            Log.d((String)"Editable", (String)"getSpanEnd");
            return 0;
        }

        public int getSpanFlags(Object tag) {
            Log.d((String)"Editable", (String)"getSpanFlags");
            return 0;
        }

        public int getSpanStart(Object tag) {
            Log.d((String)"Editable", (String)"getSpanStart");
            return 0;
        }

        public <T> T[] getSpans(int arg0, int arg1, Class<T> arg2) {
            Log.d((String)"Editable", (String)"getSpans");
            return null;
        }

        public int nextSpanTransition(int start, int limit, Class type) {
            Log.d((String)"Editable", (String)"nextSpanTransition");
            return 0;
        }

        public Editable append(CharSequence text) {
            Log.d((String)"Editable", (String)("append: " + text));
            return this;
        }

        public Editable append(char text) {
            Log.d((String)"Editable", (String)("append: " + text));
            return this;
        }

        public Editable append(CharSequence text, int start, int end) {
            Log.d((String)"Editable", (String)("append: " + text));
            return this;
        }

        public void clear() {
            Log.d((String)"Editable", (String)"clear");
        }

        public void clearSpans() {
            Log.d((String)"Editable", (String)"clearSpanes");
        }

        public Editable delete(int st, int en) {
            Log.d((String)"Editable", (String)("delete, " + st + ", " + en));
            return this;
        }

        public InputFilter[] getFilters() {
            Log.d((String)"Editable", (String)"getFilters");
            return new InputFilter[0];
        }

        public Editable insert(int where, CharSequence text) {
            Log.d((String)"Editable", (String)("insert: " + text));
            return this;
        }

        public Editable insert(int where, CharSequence text, int start, int end) {
            Log.d((String)"Editable", (String)("insert: " + text));
            return this;
        }

        public Editable replace(int st, int en, CharSequence text) {
            Log.d((String)"Editable", (String)("replace: " + text));
            return this;
        }

        public Editable replace(int st, int en, CharSequence source, int start, int end) {
            Log.d((String)"Editable", (String)("replace: " + source));
            return this;
        }

        public void setFilters(InputFilter[] filters) {
            Log.d((String)"Editable", (String)"setFilters");
        }
    }
}

