//-------------------------------------------------------------------------------------------------
// File : main.cpp
// Desc : Main Entry Point.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <a3d.h>
#include <cstdlib>
#include <cassert>
#include <SampleApp.h>


//-------------------------------------------------------------------------------------------------
// Forward declarations.
//-------------------------------------------------------------------------------------------------
bool InitA3D();
void TermA3D();
void DrawA3D();
void Resize(uint32_t w, uint32_t h, void* ptr);

//-------------------------------------------------------------------------------------------------
// Global Varaibles.
//-------------------------------------------------------------------------------------------------
IApp*               g_pApp              = nullptr;  //!< EBhE̐swp[NXł.
a3d::IDevice*       g_pDevice           = nullptr;  //!< foCXł.
a3d::ISwapChain*    g_pSwapChain        = nullptr;  //!< Xbv`FCł.
a3d::IQueue*        g_pGraphicsQueue    = nullptr;  //!< R}hL[ł.
a3d::IFence*        g_pFence            = nullptr;  //!< tFXł.
a3d::ITexture*      g_pColorBuffer[2]   = {};       //!< J[obt@ł.
a3d::ITextureView*  g_pColorView[2]     = {};       //!< J[r[ł.
a3d::ICommandList*  g_pCommandList[2]   = {};       //!< R}hXgł.
a3d::IFrameBuffer*  g_pFrameBuffer[2]   = {};       //!< t[obt@ł.
bool                g_Prepare           = false;    //!< otrue.


///////////////////////////////////////////////////////////////////////////////////////////////////
// Allocator class
///////////////////////////////////////////////////////////////////////////////////////////////////
class Allocator : public a3d::IAllocator
{
    //=============================================================================================
    // list of friend classes and methods.
    //=============================================================================================
    /* NONTHING */

public:
    //=============================================================================================
    // public variables.
    //=============================================================================================
    /* NOHTING */

    //=============================================================================================
    // public methods.
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    //      mۂ܂.
    //---------------------------------------------------------------------------------------------
    void* Alloc(size_t size, size_t alignment) noexcept override
    {
        #if A3D_IS_WIN
            return _aligned_malloc(size, alignment);
        #else
            return aligned_alloc(alignment, size);
        #endif
    }

    //---------------------------------------------------------------------------------------------
    //      Ċmۂ܂.
    //---------------------------------------------------------------------------------------------
    void* Realloc(void* ptr, size_t size, size_t alignment) noexcept override
    {
        #if A3D_IS_WIN
            return _aligned_realloc(ptr, size, alignment);
        #else
            A3D_UNUSED(alignment);
            return realloc(ptr, size);
        #endif
    }

    //---------------------------------------------------------------------------------------------
    //      ܂.
    //---------------------------------------------------------------------------------------------
    void Free(void* ptr) noexcept override
    {
        #if A3D_IS_WIN
            _aligned_free(ptr);
        #else
            free(ptr);
        #endif
    }
} g_Allocator;


//-------------------------------------------------------------------------------------------------
//      CGg[|Cgł.
//-------------------------------------------------------------------------------------------------
void Main()
{
    // EBhE.
    if (!CreateApp(960, 540, &g_pApp))
    { return; }

    // TCỸR[obN֐ݒ.
    g_pApp->SetResizeCallback(Resize, nullptr);

    // A3D.
    if (!InitA3D())
    {
        g_pApp->Release();
        return;
    }

    // C[v.
    while( g_pApp->IsLoop() )
    {
        // `揈.
        DrawA3D();
    }

    // n.
    TermA3D();
    g_pApp->Release();
}

//-------------------------------------------------------------------------------------------------
//      A3D̏s܂.
//-------------------------------------------------------------------------------------------------
bool InitA3D()
{
    g_Prepare = false;

    // OtBbNXVXȅ.
    {
        a3d::SystemDesc desc = {};
        desc.pAllocator = &g_Allocator;
        desc.pOption    = g_pApp->GetWindowHandle();

        if (!a3d::InitSystem(&desc))
        { return false; }
    }

    // foCX̐.
    {
        a3d::DeviceDesc desc = {};

        desc.EnableDebug = true;

        // őfBXNv^ݒ.
        desc.MaxColorTargetCount            = 2;
        desc.MaxDepthTargetCount            = 1;
        desc.MaxShaderResourceCount         = 1;

        // őTu~bgݒ.
        desc.MaxGraphicsQueueSubmitCount    = 256;
        desc.MaxCopyQueueSubmitCount        = 256;
        desc.MaxComputeQueueSubmitCount     = 256;

        // foCX𐶐.
        if (!a3d::CreateDevice(&desc, &g_pDevice))
        { return false; }

        // R}hL[擾.
        g_pDevice->GetGraphicsQueue(&g_pGraphicsQueue);
    }

    // Xbv`FC̐.
    {
    #if SAMPLE_IS_VULKAN && TARGET_PC
        auto format = a3d::RESOURCE_FORMAT_B8G8R8A8_UNORM;
    #else
        auto format = a3d::RESOURCE_FORMAT_R8G8B8A8_UNORM;
    #endif

        a3d::SwapChainDesc desc = {};
        desc.Extent.Width   = g_pApp->GetWidth();
        desc.Extent.Height  = g_pApp->GetHeight();
        desc.Format         = format;
        desc.MipLevels      = 1;
        desc.SampleCount    = 1;
        desc.BufferCount    = 2;
        desc.SyncInterval   = 1;
        desc.InstanceHandle = g_pApp->GetInstanceHandle();
        desc.WindowHandle   = g_pApp->GetWindowHandle();

        if (!g_pDevice->CreateSwapChain(&desc, &g_pSwapChain))
        { return false; }

        // Xbv`FCobt@擾.
        g_pSwapChain->GetBuffer(0, &g_pColorBuffer[0]);
        g_pSwapChain->GetBuffer(1, &g_pColorBuffer[1]);

        a3d::TextureViewDesc viewDesc = {};
        viewDesc.Dimension          = a3d::VIEW_DIMENSION_TEXTURE2D;
        viewDesc.Format             = format;
        viewDesc.TextureAspect      = a3d::TEXTURE_ASPECT_COLOR;
        viewDesc.MipSlice           = 0;
        viewDesc.MipLevels          = desc.MipLevels;
        viewDesc.FirstArraySlice    = 0;
        viewDesc.ArraySize          = 1;
        viewDesc.ComponentMapping.R = a3d::TEXTURE_SWIZZLE_R;
        viewDesc.ComponentMapping.G = a3d::TEXTURE_SWIZZLE_G;
        viewDesc.ComponentMapping.B = a3d::TEXTURE_SWIZZLE_B;
        viewDesc.ComponentMapping.A = a3d::TEXTURE_SWIZZLE_A;

        for(auto i=0; i<2; ++i)
        {
            if (!g_pDevice->CreateTextureView(g_pColorBuffer[i], &viewDesc, &g_pColorView[i]))
            { return false; }
        }
    }

    // t[obt@̐
    {
        // t[obt@̐ݒ.
        a3d::FrameBufferDesc desc = {};
        desc.ColorCount         = 1;
        desc.pColorTargets[0]   = g_pColorView[0];
        desc.pDepthTarget       = nullptr;

        // 1ڂ̃t[obt@𐶐.
        if (!g_pDevice->CreateFrameBuffer(&desc, &g_pFrameBuffer[0]))
        { return false; }

        // 2ڂ̃t[obt@𐶐.
        desc.pColorTargets[0] = g_pColorView[1];
        if (!g_pDevice->CreateFrameBuffer(&desc, &g_pFrameBuffer[1]))
        { return false; }
    }

    // R}hXg𐶐.
    {
        for(auto i=0; i<2; ++i)
        {
            if (!g_pDevice->CreateCommandList(a3d::COMMANDLIST_TYPE_DIRECT, &g_pCommandList[i]))
            { return false; }
        }
    }

    // tFX𐶐.
    {
        if (!g_pDevice->CreateFence(&g_pFence))
        { return false; }
    }

    g_Prepare = true;
    return true;
}

//-------------------------------------------------------------------------------------------------
//      A3D̏Is܂.
//-------------------------------------------------------------------------------------------------
void TermA3D()
{
    g_Prepare = false;

    // _uobt@\[X̔j.
    for(auto i=0; i<2; ++i)
    {
        // t[obt@̔j.
        a3d::SafeRelease(g_pFrameBuffer[i]);

        // J[r[̔j.
        a3d::SafeRelease(g_pColorView[i]);

        // J[obt@̔j.
        a3d::SafeRelease(g_pColorBuffer[i]);

        // R}hXg̔j.
        a3d::SafeRelease(g_pCommandList[i]);
    }

    // tFX̔j.
    a3d::SafeRelease(g_pFence);

    // Xbv`FC̔j.
    a3d::SafeRelease(g_pSwapChain);

    // OtBbNXL[̔j.
    a3d::SafeRelease(g_pGraphicsQueue);

    // foCX̔j.
    a3d::SafeRelease(g_pDevice);

    // OtBbNXVXȅI.
    a3d::TermSystem();
}

//-------------------------------------------------------------------------------------------------
//      A3Dɂ`揈s܂.
//-------------------------------------------------------------------------------------------------
void DrawA3D()
{
    if (!g_Prepare)
    { return; }

    // obt@ԍ擾܂.
    auto idx = g_pSwapChain->GetCurrentBufferIndex();

    // R}h̋L^Jn܂.
    auto pCmd = g_pCommandList[idx];
    pCmd->Begin();

    // ݗp̃oAݒ肵܂.
    pCmd->TextureBarrier(
        g_pColorBuffer[idx],
        a3d::RESOURCE_STATE_PRESENT,
        a3d::RESOURCE_STATE_COLOR_WRITE);

    // t[obt@ݒ肵܂.
    pCmd->SetFrameBuffer(g_pFrameBuffer[idx]);

    // t[obt@NA܂.
    a3d::ClearColorValue clearColor = {};
    clearColor.Float[0] = 0.25f;
    clearColor.Float[1] = 0.25f;
    clearColor.Float[2] = 0.25f;
    clearColor.Float[3] = 1.0f;
    pCmd->ClearFrameBuffer(1, &clearColor, nullptr);

    {
        /* TODO */
    }

    pCmd->SetFrameBuffer(nullptr);

    // \pɃoAݒ肵܂.
    pCmd->TextureBarrier(
        g_pColorBuffer[idx],
        a3d::RESOURCE_STATE_COLOR_WRITE,
        a3d::RESOURCE_STATE_PRESENT);

    // R}hXgւ̋L^I܂.
    pCmd->End();

    // R}hL[ɓo^܂.
    g_pGraphicsQueue->Submit(pCmd);

    // R}hs܂.
    g_pGraphicsQueue->Execute(g_pFence);

    // R}hsҋ@܂.
    if (!g_pFence->IsSignaled())
    { g_pFence->Wait(UINT32_MAX); }

    // ʂɕ\܂.
    g_pSwapChain->Present();
}

//-------------------------------------------------------------------------------------------------
//      TCYł.
//-------------------------------------------------------------------------------------------------
void Resize( uint32_t w, uint32_t h, void* pUser )
{
    A3D_UNUSED( pUser );

    // ĂȂԂCłȂ̂őI.
    if (!g_Prepare || g_pSwapChain == nullptr)
    { return; }

    // Tvȉ̏ꍇ̓NbV錴ƂȂ̂ŏȂ.
    {
        auto desc = g_pSwapChain->GetDesc();
        if ( w < desc.SampleCount || h < desc.SampleCount )
        { return; }
    }

    g_Prepare = false;

    // AChԂɂȂ܂ő҂.
    g_pGraphicsQueue->WaitIdle();
    g_pDevice->WaitIdle();

    for(auto i=0; i<2; ++i)
    {
        // t[obt@̔j.
        a3d::SafeRelease(g_pFrameBuffer[i]);

        // J[r[̔j.
        a3d::SafeRelease(g_pColorView[i]);

        // J[obt@̔j.
        a3d::SafeRelease(g_pColorBuffer[i]);
    }

    // Xbv`FC̃TCYł.
    g_pSwapChain->ResizeBuffers( w, h );

    // eNX`r[𐶐.
    {
        auto desc = g_pSwapChain->GetDesc();

        // Xbv`FCobt@擾.
        g_pSwapChain->GetBuffer(0, &g_pColorBuffer[0]);
        g_pSwapChain->GetBuffer(1, &g_pColorBuffer[1]);

        a3d::TextureViewDesc viewDesc = {};
        viewDesc.Dimension          = a3d::VIEW_DIMENSION_TEXTURE2D;
        viewDesc.Format             = desc.Format;
        viewDesc.TextureAspect      = a3d::TEXTURE_ASPECT_COLOR;
        viewDesc.MipSlice           = 0;
        viewDesc.MipLevels          = desc.MipLevels;
        viewDesc.FirstArraySlice    = 0;
        viewDesc.ArraySize          = 1;
        viewDesc.ComponentMapping.R = a3d::TEXTURE_SWIZZLE_R;
        viewDesc.ComponentMapping.G = a3d::TEXTURE_SWIZZLE_G;
        viewDesc.ComponentMapping.B = a3d::TEXTURE_SWIZZLE_B;
        viewDesc.ComponentMapping.A = a3d::TEXTURE_SWIZZLE_A;

        for(auto i=0; i<2; ++i)
        {
            auto ret = g_pDevice->CreateTextureView(g_pColorBuffer[i], &viewDesc, &g_pColorView[i]);
            assert(ret == true);
        }
    }

    // t[obt@̐
    {
        // t[obt@̐ݒ.
        a3d::FrameBufferDesc desc = {};
        desc.ColorCount         = 1;
        desc.pColorTargets[0]   = g_pColorView[0];
        desc.pDepthTarget       = nullptr;

        // 1ڂ̃t[obt@𐶐.
        auto ret = g_pDevice->CreateFrameBuffer(&desc, &g_pFrameBuffer[0]);
        assert(ret == true);

        // 2ڂ̃t[obt@𐶐.
        desc.pColorTargets[0] = g_pColorView[1];
        ret = g_pDevice->CreateFrameBuffer(&desc, &g_pFrameBuffer[1]);
        assert(ret == true);
    }

    g_Prepare = true;
}