//-------------------------------------------------------------------------------------------------
// File : gui.h
// Desc : ImGui Helper.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <a3d.h>
#include <chrono>
#include <SampleApp.h>
#include <SampleMath.h>
#include <imgui.h>


///////////////////////////////////////////////////////////////////////////////////////////////////
// GuiMgr class
///////////////////////////////////////////////////////////////////////////////////////////////////
class GuiMgr
{
    //=============================================================================================
    // list of friend classes and methods.
    //=============================================================================================

public:
    //=============================================================================================
    // public variables.
    //=============================================================================================

    //=============================================================================================
    // public methods.
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    //! @brief      VOgCX^X擾܂.
    //---------------------------------------------------------------------------------------------
    static GuiMgr& GetInstance();

    //---------------------------------------------------------------------------------------------
    //! @brief      s܂.
    //!
    //! @param[in]      pDevice         foCXł.
    //! @param[in]      pApp            Avł.
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //---------------------------------------------------------------------------------------------
    bool Init(a3d::IDevice* pDevice, a3d::IFrameBuffer* pFrameBuffer, IApp* pApp);

    //---------------------------------------------------------------------------------------------
    //! @brief      Is܂.
    //---------------------------------------------------------------------------------------------
    void Term();

    //---------------------------------------------------------------------------------------------
    //! @brief      obt@ւ܂.
    //---------------------------------------------------------------------------------------------
    void SwapBuffers();

    //---------------------------------------------------------------------------------------------
    //! @brief      `R}h쐬܂.
    //!
    //! @param[in]      pCommandList        R}hXgł.
    //---------------------------------------------------------------------------------------------
    void Issue(a3d::ICommandList* pCommandList);

private:
    //=============================================================================================
    // private variables.
    //=============================================================================================
    static GuiMgr   s_Instance;
    const uint32_t  MaxPrimitiveCount = 6 * 1024;
    a3d::IDevice*               m_pDevice;              //!< foCXł.
    a3d::IBuffer*               m_pVB[2];               //!< _obt@ł.
    a3d::IBuffer*               m_pIB[2];               //!< CfbNXobt@ł.
    a3d::IBuffer*               m_pCB[2];               //!< 萔obt@ł.
    a3d::IBufferView*           m_pCBV[2];              //!< 萔obt@r[ł.
    size_t                      m_SizeVB[2];            //!< _obt@̃TCYł.
    size_t                      m_SizeIB[2];            //!< CfbNXobt@̃TCYł.
    a3d::ISampler*              m_pSampler;             //!< Tv[ł.
    a3d::ITexture*              m_pTexture;             //!< eNX`ł.
    a3d::ITextureView*          m_pTextureView;         //!< eNX`r[ł.
    a3d::IDescriptorSetLayout*  m_pDescriptorSetLayout; //!< fBXNv^CAEgł.
    a3d::IDescriptorSet*        m_pDescriptorSet[2];    //!< fBXNv^Zbgł.
    a3d::IPipelineState*        m_pPipelineState;       //!< pCvCXe[gł.
    a3d::ICommandList*          m_pCommandList;         //!< R}hXgł.
    Mat4*                       m_pProjection[2];       //!< ˉesł.
    int                         m_BufferIndex;          //!< obt@ԍł.
    IApp*                       m_pApp;                 //!< AvP[Vł.
    std::chrono::system_clock::time_point m_LastTime;

    //=============================================================================================
    // private methods.
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //---------------------------------------------------------------------------------------------
    GuiMgr();

    //---------------------------------------------------------------------------------------------
    //! @brief      fXgN^ł.
    //---------------------------------------------------------------------------------------------
    ~GuiMgr();

    //---------------------------------------------------------------------------------------------
    //! @brief      }EXR[obNł.
    //!
    //! @param[in]      x               }EXJ[\XWł.
    //! @param[in]      y               }EXJ[\YWł.
    //! @param[in]      whleelDelta     }EXzC[̈ړʂł.
    //! @param[in]      isDownL         }EX{^Ă true.
    //! @param[in]      isDownM         }EX{^Ă true.
    //! @param[in]      isDownR         }EXE{^Ă true.
    //---------------------------------------------------------------------------------------------
    void OnMouse(int x, int y, int wheelDelta, bool isDownL, bool isDownM, bool isDownR);

    //---------------------------------------------------------------------------------------------
    //! @brief      L[{[hR[obNł.
    //!
    //! @param[in]      keyCode         L[R[hł.
    //! @param[in]      isKeyDown       L[Ă true.
    //! @param[in]      isAltDown       ALTL[Ă true.
    //---------------------------------------------------------------------------------------------
    void OnKeyboard(uint32_t keyCode, bool isKeyDown, bool isAltDown);

    //---------------------------------------------------------------------------------------------
    //! @brief      ̓R[obNł.
    //---------------------------------------------------------------------------------------------
    void OnChar(uint32_t keyCode);

    //---------------------------------------------------------------------------------------------
    //! @brief      `R}h쐬܂.
    //---------------------------------------------------------------------------------------------
    void OnDraw(ImDrawData* pData);
    static void Draw(ImDrawData* pData);

    GuiMgr          (const GuiMgr&) = delete;
    void operator = (const GuiMgr&) = delete;
};
