//-------------------------------------------------------------------------------------------------
// File : SampleApp.h
// Desc : Sample Application.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <cstdint>


//-------------------------------------------------------------------------------------------------
// Type definition.
//-------------------------------------------------------------------------------------------------
typedef void (*MouseCallback)(int x, int y, int wheelDelta, bool leftDown, bool middleDown, bool rightDown, void* pUser);
typedef void (*KeyboardCallback)(bool keyDown, bool altDown, uint32_t keyCode, void* pUser);
typedef void (*CharCallback)(uint32_t keyCode, void* pUser);
typedef void (*ResizeCallback)(uint32_t w, uint32_t h, void* pUser);


///////////////////////////////////////////////////////////////////////////////////////////////////
// IApp interface
///////////////////////////////////////////////////////////////////////////////////////////////////
struct IApp
{
    //---------------------------------------------------------------------------------------------
    //! @brief      fXgN^ł.
    //---------------------------------------------------------------------------------------------
    virtual ~IApp()
    { /* DO_NOTHING */ }

    //---------------------------------------------------------------------------------------------
    //! @brief      s܂.
    //---------------------------------------------------------------------------------------------
    virtual void Release() = 0;

    //---------------------------------------------------------------------------------------------
    //! @brief      C[v𑱍s邩ǂ.
    //!
    //! @retval true    C[v𑱍s܂.
    //! @retval false   C[vI܂.
    //---------------------------------------------------------------------------------------------
    virtual bool IsLoop() = 0;

    //---------------------------------------------------------------------------------------------
    //! @brief      Ivo܂.
    //---------------------------------------------------------------------------------------------
    virtual void PostQuit() = 0;

    //---------------------------------------------------------------------------------------------
    //! @brief      EBhẺ擾܂.
    //!
    //! @return     EBhẺԋp܂.
    //---------------------------------------------------------------------------------------------
    virtual uint32_t GetWidth() const = 0;

    //---------------------------------------------------------------------------------------------
    //! @brief      EBhȄc擾܂.
    //!
    //! @return     EBhȄcԋp܂.
    //---------------------------------------------------------------------------------------------
    virtual uint32_t GetHeight() const = 0;

    //---------------------------------------------------------------------------------------------
    //! @brief      CX^Xnh擾܂.
    //!
    //! @return     CX^Xnhԋp܂.
    //---------------------------------------------------------------------------------------------
    virtual void* GetInstanceHandle() const = 0;

    //---------------------------------------------------------------------------------------------
    //! @brief      EBhEnh擾܂.
    //!
    //! @return     EBhEnhԋp܂.
    //---------------------------------------------------------------------------------------------
    virtual void* GetWindowHandle() const = 0;

    //---------------------------------------------------------------------------------------------
    //! @brief      }EXR[obN֐ݒ肵܂.
    //!
    //! @param[in]      pFunc       ݒ肷R[obN֐ł.
    //! @param[in]      pUser       [U[|C^ł.
    //---------------------------------------------------------------------------------------------
    virtual void SetMouseCallback(MouseCallback pFunc, void* pUser) = 0;

    //---------------------------------------------------------------------------------------------
    //! @brief      L[{[hR[obN֐ݒ肵܂.
    //!
    //! @param[in]      pFunc       ݒ肷R[obN֐ł.
    //! @param[in]      pUser       [U[|C^ł.
    //---------------------------------------------------------------------------------------------
    virtual void SetKeyboardCallback(KeyboardCallback pFunc, void* pUser) = 0;

    //---------------------------------------------------------------------------------------------
    //! @brief      ̓R[obN֐ݒ肵܂.
    //!
    //! @param[in]      pFunc       ݒ肷R[obN֐ł.
    //! @param[in]      pUser       [U[|C^ł.
    //---------------------------------------------------------------------------------------------
    virtual void SetCharCallback(CharCallback pFunc, void* pUser) = 0;

    //---------------------------------------------------------------------------------------------
    //! @brief      TCYR[obN֐ݒ肵܂.
    //!
    //! @param[in]      pFunc       ݒ肷R[obN֐ł.
    //! @param[in]      pUser       [U[|C^ł.
    //---------------------------------------------------------------------------------------------
    virtual void SetResizeCallback(ResizeCallback pFunc, void* pUser) = 0;
};

//-------------------------------------------------------------------------------------------------
//! @brief      AvP[V𐶐܂.
//!
//! @param[in]      width       EBhẺł.
//! @param[in]      height      EBhȄcł.
//! @param[out]     ppApp       AvP[V̊i[ł.
//! @retval true    ɐ.
//! @retval false   Ɏs.
//-------------------------------------------------------------------------------------------------
bool CreateApp(uint32_t width, uint32_t height, IApp** ppApp);

//-------------------------------------------------------------------------------------------------
//! @brief      C֐ł.
//-------------------------------------------------------------------------------------------------
void Main();
