//-------------------------------------------------------------------------------------------------
// File : SampleAppWin.cpp
// Desc : Sample Application Implementation for Windows Platform.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------

#if defined(WIN32) || defined(_WIN32) || defined(WIN64)

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include "SampleApp.h"
#include <Windows.h>


namespace {

//-------------------------------------------------------------------------------------------------
// Global variables.
//-------------------------------------------------------------------------------------------------
const auto WindowClassName = TEXT("A3D_Sample");


///////////////////////////////////////////////////////////////////////////////////////////////////
// App class
///////////////////////////////////////////////////////////////////////////////////////////////////
class App : public IApp
{
    //=============================================================================================
    // list of friend classes and methods.
    //=============================================================================================
    /* NOTHING */

public:
    //=============================================================================================
    // public variables.
    //=============================================================================================
    /* NOTHING */

    //=============================================================================================
    // public methods
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    //      RXgN^ł.
    //---------------------------------------------------------------------------------------------
    App()
    : m_hInst           (nullptr)
    , m_hWnd            (nullptr)
    , m_Msg             ()
    , m_Width           (0)
    , m_Height          (0)
    , m_OnMouse         (nullptr)
    , m_pUserMouse      (nullptr)
    , m_OnKeyborad      (nullptr)
    , m_pUserKeyboard   (nullptr)
    { /* DO_NOTHING */ }

    //---------------------------------------------------------------------------------------------
    //      fXgN^ł.
    //---------------------------------------------------------------------------------------------
    virtual ~App()
    { Term(); }

    //---------------------------------------------------------------------------------------------
    //      ł.
    //---------------------------------------------------------------------------------------------
    bool Init(uint32_t width, uint32_t height)
    {
        // CX^Xnh擾.
        HINSTANCE hInst = GetModuleHandle( nullptr );
        if ( !hInst )
        { return false; }

        m_Width  = width;
        m_Height = height;

        // gEBhENX̐ݒ.
        WNDCLASSEX wc;
        wc.cbSize           = sizeof( WNDCLASSEX );
        wc.style            = CS_HREDRAW | CS_VREDRAW;
        wc.lpfnWndProc      = WndProc;
        wc.cbClsExtra       = 0;
        wc.cbWndExtra       = 0;
        wc.hInstance        = hInst;
        wc.hIcon            = LoadIcon( hInst, IDI_APPLICATION );
        wc.hCursor          = LoadCursor( NULL, IDC_ARROW );
        wc.hbrBackground    = (HBRUSH)( COLOR_WINDOW + 1 );
        wc.lpszMenuName     = NULL;
        wc.lpszClassName    = WindowClassName;
        wc.hIconSm          = LoadIcon( hInst, IDI_APPLICATION );

        // EBhENXo^܂.
        if ( !RegisterClassEx( &wc ) )
        { return false; }

        // CX^Xnhݒ.
        m_hInst = hInst;

        // `̐ݒ.
        RECT rc = { 0, 0, static_cast<LONG>(m_Width), static_cast<LONG>(m_Height) };

        // w肳ꂽNCAg̈mۂ邽߂ɕKvȃEBhEWvZ܂.
        DWORD style = WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MAXIMIZEBOX | WS_MINIMIZEBOX | WS_THICKFRAME;
        AdjustWindowRect( &rc, style, FALSE );

        // EBhE𐶐܂.
        m_hWnd = CreateWindow(
            WindowClassName,
            WindowClassName,
            style,
            CW_USEDEFAULT,
            CW_USEDEFAULT,
            ( rc.right - rc.left ),
            ( rc.bottom - rc.top ),
            NULL,
            NULL,
            hInst,
            this
        );

        // `FbN.
        if ( !m_hWnd )
        { return false; }

        // EBhE\܂.
        ShowWindow( m_hWnd, SW_SHOWNORMAL );
        UpdateWindow( m_hWnd );

        // tH[JXݒ肵܂.
        SetFocus( m_hWnd );

        return true;
    }

    //---------------------------------------------------------------------------------------------
    //      Ił.
    //---------------------------------------------------------------------------------------------
    void Term()
    {
        if (m_hInst != nullptr)
        {
            UnregisterClass(WindowClassName, m_hInst);
            m_hInst = nullptr;
        }
    }

    //---------------------------------------------------------------------------------------------
    //      ł.
    //---------------------------------------------------------------------------------------------
    void Release() override
    { delete this; }

    //---------------------------------------------------------------------------------------------
    //      C[v𑱍s邩ǂ?
    //---------------------------------------------------------------------------------------------
    bool IsLoop() override
    {
        if ( PeekMessage(&m_Msg, nullptr, 0, 0, PM_REMOVE ) != 0 )
        {
            TranslateMessage( &m_Msg );
            DispatchMessage( &m_Msg );
        }

        return m_Msg.message != WM_QUIT;
    }

    //---------------------------------------------------------------------------------------------
    //      Ivo܂.
    //---------------------------------------------------------------------------------------------
    void PostQuit() override
    { PostQuitMessage(0); }

    //---------------------------------------------------------------------------------------------
    //      EBhẺ擾܂.
    //---------------------------------------------------------------------------------------------
    uint32_t GetWidth() const override
    { return m_Width; }

    //---------------------------------------------------------------------------------------------
    //      EBhȄc擾܂.
    //---------------------------------------------------------------------------------------------
    uint32_t GetHeight() const override
    { return m_Height; }

    //---------------------------------------------------------------------------------------------
    //      CX^Xnh擾܂.
    //---------------------------------------------------------------------------------------------
    void* GetInstanceHandle() const override
    { return reinterpret_cast<void*>(m_hInst); }

    //---------------------------------------------------------------------------------------------
    //      EBhEnh擾܂.
    //---------------------------------------------------------------------------------------------
    void* GetWindowHandle() const override
    { return reinterpret_cast<void*>(m_hWnd); }

    //---------------------------------------------------------------------------------------------
    //      }EXR[obN֐ݒ肵܂.
    //---------------------------------------------------------------------------------------------
    void SetMouseCallback(MouseCallback pFunc, void* pUser) override
    {
        m_OnMouse    = pFunc;
        m_pUserMouse = pUser;
    }

    //---------------------------------------------------------------------------------------------
    //      L[{[hR[obN֐ݒ肵܂.
    //---------------------------------------------------------------------------------------------
    void SetKeyboardCallback(KeyboardCallback pFunc, void* pUser) override
    {
        m_OnKeyborad    = pFunc;
        m_pUserKeyboard = pUser;
    }

    //---------------------------------------------------------------------------------------------
    //      ̓R[obN֐ݒ肵܂.
    //---------------------------------------------------------------------------------------------
    void SetCharCallback(CharCallback pFunc, void* pUser) override
    {
        m_OnChar    = pFunc;
        m_pUserChar = pUser;
    }

    //---------------------------------------------------------------------------------------------
    //      TCYR[obN֐ݒ肵܂.
    //---------------------------------------------------------------------------------------------
    void SetResizeCallback(ResizeCallback pFunc, void* pUser) override
    {
        m_OnResize    = pFunc;
        m_pUserResize = pUser;
    }

private:
    //=============================================================================================
    // private variables.
    //=============================================================================================
    HINSTANCE   m_hInst;        //!< CX^Xnhł.
    HWND        m_hWnd;         //!< EBhEnhł.
    MSG         m_Msg;          //!< bZ[Wł.
    uint32_t    m_Width;        //!< EBhẺł.
    uint32_t    m_Height;       //!< EBhȄcł.

    MouseCallback       m_OnMouse;          //!< }EXR[obN֐ł.
    void*               m_pUserMouse;       //!< }EXR[obÑ[U[f[^ł.
    KeyboardCallback    m_OnKeyborad;       //!< L[{[hR[obN֐ł.
    void*               m_pUserKeyboard;    //!< L[{[hR[obÑ[U[f[^ł.
    CharCallback        m_OnChar;           //!< ̓R[obN֐ł.
    void*               m_pUserChar;        //!< ̓R[obÑ[U[f[^ł.
    ResizeCallback      m_OnResize;         //!< TCYR[obN֐ł.
    void*               m_pUserResize;      //!< TCYR[obÑ[U[f[^ł.

    //=============================================================================================
    // private methods.
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    //      EBhEvV[Wł.
    //---------------------------------------------------------------------------------------------
    static LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
    {
        auto instance = reinterpret_cast<App*>(GetWindowLongPtr(hWnd, GWLP_USERDATA));

        const UINT OLD_WM_MOUSEWHEEL = 0x020A;

        if (msg == WM_KEYDOWN    ||
            msg == WM_SYSKEYDOWN ||
            msg == WM_KEYUP      ||
            msg == WM_SYSKEYUP)
        {
            // ESCL[ꂽI.
            if ( wp == 0x1b )
            {
                PostQuitMessage(0);
                return 0;
            }

            if ( instance->m_OnKeyborad == nullptr)
            { return 0; }

            auto isKeyDown = ( msg == WM_KEYDOWN ) || ( msg == WM_SYSKEYDOWN );
            uint32_t mask  = ( 1 << 29 );
            auto isAltDown = ( ( lp & mask ) != 0 );

            instance->m_OnKeyborad(isKeyDown, isAltDown, uint32_t(wp), instance->m_pUserKeyboard);
        }

        if (msg == WM_LBUTTONDOWN   ||
            msg == WM_LBUTTONUP     ||
            msg == WM_LBUTTONDBLCLK ||
            msg == WM_MBUTTONDOWN   ||
            msg == WM_MBUTTONUP     ||
            msg == WM_MBUTTONDBLCLK ||
            msg == WM_RBUTTONDOWN   ||
            msg == WM_RBUTTONUP     ||
            msg == WM_RBUTTONDBLCLK ||
            msg == WM_MOUSEWHEEL    ||
            msg == WM_MOUSEMOVE     ||
            msg == WM_XBUTTONDOWN   ||
            msg == WM_XBUTTONUP     ||
            msg == WM_XBUTTONDBLCLK)
        {
            if ( instance->m_OnMouse == nullptr )
            { return 0; }

            auto x = static_cast<int>( (int16_t)LOWORD( lp ) );
            auto y = static_cast<int>( (int16_t)HIWORD( lp ) );
            auto wheelDelta = 0;

            if ( msg == WM_MOUSEHWHEEL )
            {
                wheelDelta += static_cast<int16_t>( wp );
            }

            auto state = LOWORD( wp );
            auto isDownL  = ( ( state & MK_LBUTTON )  != 0 );
            auto isDownR  = ( ( state & MK_RBUTTON )  != 0 );
            auto isDownM  = ( ( state & MK_MBUTTON )  != 0 );
            //auto isDownX1 = ( ( state & MK_XBUTTON1 ) != 0 );
            //auto isDownX2 = ( ( state & MK_XBUTTON2 ) != 0 );

            instance->m_OnMouse(x, y, wheelDelta, isDownL, isDownM, isDownR, instance->m_pUserMouse);
        }

        switch( msg )
        {
            case WM_CREATE:
            {
                auto pCreateStruct = reinterpret_cast<LPCREATESTRUCT>(lp);
                SetWindowLongPtr(hWnd, GWLP_USERDATA, reinterpret_cast<LONG_PTR>(pCreateStruct->lpCreateParams));
            }
            break;

        case WM_DESTROY:
            { PostQuitMessage(0); }
            break;

        case WM_CLOSE:
            { DestroyWindow(hWnd); }
            break;

        case WM_CHAR:
            {
                if ( instance->m_OnChar == nullptr )
                { return 0; }

                instance->m_OnChar( uint32_t(wp), instance->m_pUserChar );
            }
            break;

        case WM_SIZE:
            {
                auto w = static_cast<uint32_t>(LOWORD(lp));
                auto h = static_cast<uint32_t>(HIWORD(lp));

                instance->m_Width  = w;
                instance->m_Height = h;
                
                if ( instance->m_OnResize == nullptr )
                { return 0; }

                instance->m_OnResize( LOWORD(lp), HIWORD(lp), instance->m_pUserResize );
            }
            break;

        default:
            break;
        }

        return DefWindowProc(hWnd, msg, wp, lp);
    }
};

} // namespace


//-------------------------------------------------------------------------------------------------
//      AvP[V𐶐܂.
//-------------------------------------------------------------------------------------------------
bool CreateApp(uint32_t width, uint32_t height, IApp** ppApp)
{
    if (width == 0 && height == 0)
    { return false; }

    if (ppApp == nullptr)
    { return false; }

    auto instance = new App;
    if (!instance->Init(width, height))
    {
        instance->Release();
        return false;
    }

    *ppApp = instance;
    return true;
}

//-------------------------------------------------------------------------------------------------
//     CGg[|Cgł.
//-------------------------------------------------------------------------------------------------
void main()
{ Main(); }

#endif// defined(WIN32) || defined(_WIN32) || defined(WIN64)
