﻿//-------------------------------------------------------------------------------------------------
// File : SampleUtil.h
// Desc : Sample Utility.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <a3d.h>
#include <string>

//-------------------------------------------------------------------------------------------------
//! @brief      サンプルプログラムに使用するシェーダのディレクトリパスを取得します.
//-------------------------------------------------------------------------------------------------
std::string GetShaderDirectoryForSampleProgram();

//-------------------------------------------------------------------------------------------------
//! @brief      サンプルプログラムに使用するテクスチャのディレクトリパスを取得します.
//-------------------------------------------------------------------------------------------------
std::string GetTextureDirectoryForSampleProgram();

//-------------------------------------------------------------------------------------------------
//! @brief      シェーダバイナリを読み込みます.
//!
//! @param[in]      filename    ファイル名です.
//! @param[out]     result      シェーダバイナリの格納先です.
//! @retval true    読み込みに成功.
//! @retval false   読み込みに失敗.
//-------------------------------------------------------------------------------------------------
bool LoadShaderBinary(const char* filename, a3d::ShaderBinary& result );

//-------------------------------------------------------------------------------------------------
//! @brief      シェーダバイナリを破棄します.
//!
//! @param[in]      binary      破棄するシェーダバイナリです.
//-------------------------------------------------------------------------------------------------
void DisposeShaderBinary(a3d::ShaderBinary& binary);
