﻿//-------------------------------------------------------------------------------------------------
// File : a3dDescriptor.cpp
// Desc : Descriptor Moudle.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------


namespace a3d {

///////////////////////////////////////////////////////////////////////////////////////////////////
// Descriptor class
///////////////////////////////////////////////////////////////////////////////////////////////////

//-------------------------------------------------------------------------------------------------
//      コンストラクタです.
//-------------------------------------------------------------------------------------------------
Descriptor::Descriptor()
: m_pHeap       (nullptr)
, m_HandleCPU   ()
, m_HandleGPU   ()
, m_RefCount    (1)
{ /* DO_NOTHING */ }

//-------------------------------------------------------------------------------------------------
//      デストラクタです.
//-------------------------------------------------------------------------------------------------
Descriptor::~Descriptor()
{
    auto pHeap = m_pHeap;
    A3D_ASSERT(pHeap != nullptr);
    pHeap->DisposeDescriptor(this);
}

//-------------------------------------------------------------------------------------------------
//      参照カウントを増やします.
//-------------------------------------------------------------------------------------------------
void Descriptor::AddRef()
{ m_RefCount++; }

//-------------------------------------------------------------------------------------------------
//      解放処理を行います.
//-------------------------------------------------------------------------------------------------
void Descriptor::Release()
{
    m_RefCount--;
    if (m_RefCount == 0)
    { this->~Descriptor(); }
}

//-------------------------------------------------------------------------------------------------
//      参照カウントを取得します.
//-------------------------------------------------------------------------------------------------
uint32_t Descriptor::GetCount() const
{ return m_RefCount; }

//-------------------------------------------------------------------------------------------------
//      CPUディスクリプタハンドルを取得します.
//-------------------------------------------------------------------------------------------------
D3D12_CPU_DESCRIPTOR_HANDLE Descriptor::GetHandleCPU() const
{ return m_HandleCPU; }

//-------------------------------------------------------------------------------------------------
//      GPUディスクリプタハンドルを取得します.
//-------------------------------------------------------------------------------------------------
D3D12_GPU_DESCRIPTOR_HANDLE Descriptor::GetHandleGPU() const
{ return m_HandleGPU; }

} // namespace a3d
