﻿//------------------------------------------------------------------------------------------------
// File : a3dDescriptorHeap.h
// Desc : Descriptor Heap Module.
// Copyright(c) Project Asura. All right reserved.
//------------------------------------------------------------------------------------------------
#pragma once


namespace a3d {

///////////////////////////////////////////////////////////////////////////////////////////////////
// DescriptorHeap class
///////////////////////////////////////////////////////////////////////////////////////////////////
class A3D_API DescriptorHeap : public BaseAllocator
{
    //=============================================================================================
    // list of friend classes and methods.
    //=============================================================================================
    friend class Descriptor;

public:
    //=============================================================================================
    // public variables.
    //=============================================================================================
    /* NOTHING */

    //=============================================================================================
    // public methods.
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    //! @brief      コンストラクタです.
    //---------------------------------------------------------------------------------------------
    A3D_APIENTRY DescriptorHeap();

    //---------------------------------------------------------------------------------------------
    //! @brief      デストラクタです.
    //---------------------------------------------------------------------------------------------
    A3D_APIENTRY ~DescriptorHeap();

    //---------------------------------------------------------------------------------------------
    //! @brief      初期化処理を行います.
    //---------------------------------------------------------------------------------------------
    bool A3D_APIENTRY Init(ID3D12Device* pDevice, const D3D12_DESCRIPTOR_HEAP_DESC* pDesc);

    //---------------------------------------------------------------------------------------------
    //! @brief      終了処理を行います.
    //---------------------------------------------------------------------------------------------
    void A3D_APIENTRY Term();

    //---------------------------------------------------------------------------------------------
    //! @brief      ディスクリプタを生成します.
    //!
    //! @return     生成したディスクリプタを返却します. 生成に失敗した場合は nullptr が返却されます.
    //---------------------------------------------------------------------------------------------
    Descriptor* A3D_APIENTRY CreateDescriptor();

    //---------------------------------------------------------------------------------------------
    //! @brief      利用可能なハンドル数を取得します.
    //!
    //! @return     利用可能なハンドル数を返却します.
    //---------------------------------------------------------------------------------------------
    uint32_t A3D_APIENTRY GetAvailableHandleCount() const;

    //---------------------------------------------------------------------------------------------
    //! @brief      割り当て済みハンドル数を取得します.
    //!
    //! @return     割り当て済みハンドル数を返却します.
    //---------------------------------------------------------------------------------------------
    uint32_t A3D_APIENTRY GetAllocatedHandleCount() const;

    //---------------------------------------------------------------------------------------------
    //! @brief      ハンドル総数を取得します.
    //!
    //! @return     ハンドル総数を返却します.
    //---------------------------------------------------------------------------------------------
    uint32_t A3D_APIENTRY GetHandleCount() const;

    //---------------------------------------------------------------------------------------------
    //! @brief      ディスクリプタヒープを取得します.
    //---------------------------------------------------------------------------------------------
    ID3D12DescriptorHeap* A3D_APIENTRY GetD3D12DescriptorHeap() const;

private:
    //=============================================================================================
    // private variables.
    //=============================================================================================
    ID3D12DescriptorHeap*   m_pHeap;            //!< ディスクリプタヒープです.
    Pool<Descriptor>        m_Pool;             //!< プールです
    uint32_t                m_IncrementSize;    //!< インクリメントサイズです.

    //=============================================================================================
    // private methods.
    //=============================================================================================
    void DisposeDescriptor(Descriptor* pValue);

    DescriptorHeap  (const DescriptorHeap&) = delete;
    void operator = (const DescriptorHeap&) = delete;
};

} // namespace a3d
