﻿//-------------------------------------------------------------------------------------------------
// File : a3dBlob.cpp
// Desc : Binary Large Object Module.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------


namespace a3d {

///////////////////////////////////////////////////////////////////////////////////////////////////
// Blob class
///////////////////////////////////////////////////////////////////////////////////////////////////

//-------------------------------------------------------------------------------------------------
//      コンストラクタです.
//-------------------------------------------------------------------------------------------------
Blob::Blob()
: m_RefCount(1)
, m_pBuffer (nullptr)
, m_Size    (0)
{ /* DO_NOTHING */ }

//-------------------------------------------------------------------------------------------------
//      デストラクタです.
//-------------------------------------------------------------------------------------------------
Blob::~Blob()
{ Term(); }

//-------------------------------------------------------------------------------------------------
//      初期化処理を行います.
//-------------------------------------------------------------------------------------------------
bool Blob::Init(size_t size)
{
    // 解放しておく.
    Term();

    // メモリ確保.
    m_pBuffer = a3d_alloc(size, DefaultAlignment);

    // nullptrじゃなければ成功.
    return m_pBuffer != nullptr;
}

//-------------------------------------------------------------------------------------------------
//      終了処理を行います.
//-------------------------------------------------------------------------------------------------
void Blob::Term()
{
    if (m_pBuffer != nullptr)
    {
        a3d_free(m_pBuffer);
        m_pBuffer = nullptr;
    }
}

//-------------------------------------------------------------------------------------------------
//      参照カウンタを増やします.
//-------------------------------------------------------------------------------------------------
void Blob::AddRef()
{ m_RefCount++; }

//-------------------------------------------------------------------------------------------------
//      解放処理を行います.
//-------------------------------------------------------------------------------------------------
void Blob::Release()
{
    m_RefCount--;
    if (m_RefCount == 0)
    { delete this; }
}

//-------------------------------------------------------------------------------------------------
//      参照カウンタを取得します.
//-------------------------------------------------------------------------------------------------
uint32_t Blob::GetCount() const
{ return m_RefCount; }

//-------------------------------------------------------------------------------------------------
//      バッファポインタを取得します.
//-------------------------------------------------------------------------------------------------
void* Blob::GetBufferPointer() const
{ return m_pBuffer; }

//-------------------------------------------------------------------------------------------------
//      バッファサイズを取得します.
//-------------------------------------------------------------------------------------------------
uint64_t Blob::GetBufferSize() const
{ return m_Size; }

//-------------------------------------------------------------------------------------------------
//      生成処理を行います.
//-------------------------------------------------------------------------------------------------
bool Blob::Create(size_t size, IBlob** ppBlob)
{
    auto instance = new Blob();
    if (instance == nullptr)
    { return false; }

    if (!instance->Init(size))
    {
        instance->Release();
        return false;
    }

    *ppBlob = instance;

    return true;
}

//-------------------------------------------------------------------------------------------------
//      バイナリラージオブジェクトを生成します.
//-------------------------------------------------------------------------------------------------
bool A3D_APIENTRY CreateBlob(size_t size, IBlob** ppBlob)
{ return Blob::Create(size, ppBlob); }

} // namespace a3d
