﻿//-------------------------------------------------------------------------------------------------
// File : a3dInlines.h
// Desc : Inline Functions.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once


namespace a3d {

//-------------------------------------------------------------------------------------------------
//      最大値を取得します.
//-------------------------------------------------------------------------------------------------
template<typename T> inline
T Max(const T& a, const T& b)
{ return (a > b) ? a : b; }

//-------------------------------------------------------------------------------------------------
//      最小値を取得します.
//-------------------------------------------------------------------------------------------------
template<typename T> inline
T Min(const T& a, const T& b)
{ return (a < b) ? a : b; }

//-------------------------------------------------------------------------------------------------
//      配列数を取得します. (注:静的な配列のみしか正しく適用できないので使用する場合は要注意).
//-------------------------------------------------------------------------------------------------
template<typename T, size_t Count> inline
size_t CountOf(const T (&)[Count])
{ return Count; }

//-------------------------------------------------------------------------------------------------
//      nullptr を考慮して delete を呼び出します.
//-------------------------------------------------------------------------------------------------
template<typename T> inline
void SafeDelete(T*& ptr)
{
    if (ptr != nullptr)
    {
        delete ptr;
        ptr = nullptr;
    }
}

//-------------------------------------------------------------------------------------------------
//      nullptr を考慮して delete[] を呼び出します.
//-------------------------------------------------------------------------------------------------
template<typename T> inline
void SafeDeleteArray(T*& ptr)
{
    if (ptr != nullptr)
    {
        delete [] ptr;
        ptr = nullptr;
    }
}

} // namespace a3d
