﻿//-------------------------------------------------------------------------------------------------
// File : fndLfuCache.h
// Desc : Least Frequency Used Cache Module.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <map>


namespace fnd {

///////////////////////////////////////////////////////////////////////////////////////////////////
// LfuCache class
///////////////////////////////////////////////////////////////////////////////////////////////////
template<typename T, class Allocator = std::allocator<T>>
class LfuCache
{
    //=============================================================================================
    // list of friend classes and methods.
    //=============================================================================================
    /* NOTHING */

public:
    //=============================================================================================
    // public variables.
    //=============================================================================================
    /* NOTHING */

    //=============================================================================================
    // public methods.
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    //! @brief      コンストラクタです.
    //---------------------------------------------------------------------------------------------
    LfuCache(size_t capacity);

    //---------------------------------------------------------------------------------------------
    //! @brief      デストラクタです.
    //---------------------------------------------------------------------------------------------
    ~LfuCache();

    //---------------------------------------------------------------------------------------------
    //! @brief      要素を追加します.
    //---------------------------------------------------------------------------------------------
    void Add(const T& item);

    //---------------------------------------------------------------------------------------------
    //! @brief      要素の削除します.
    //---------------------------------------------------------------------------------------------
    void Remove(const T& item);

    //---------------------------------------------------------------------------------------------
    //! @brief      全要素を削除します.
    //---------------------------------------------------------------------------------------------
    void Clear();

    //---------------------------------------------------------------------------------------------
    //! @brief      要素が含まれているか判定します.
    //---------------------------------------------------------------------------------------------
    bool Contains(const T& item) const;

    //---------------------------------------------------------------------------------------------
    //! @brief      配列にコピーします.
    //---------------------------------------------------------------------------------------------
    void Copy(T* pArray, size_t offset) const;

    //---------------------------------------------------------------------------------------------
    //! @brief      最大収容可能数を取得します.
    //---------------------------------------------------------------------------------------------
    size_t GetCapacity() const;

    //---------------------------------------------------------------------------------------------
    //! @brief      現在の収容数を取得します.
    //---------------------------------------------------------------------------------------------
    size_t GetCount() const;

private:
    //=============================================================================================
    // private variables.
    //=============================================================================================
    size_t                          m_Capacity;
    std::map<T, size_t, Allocator>  m_Cache;

    //=============================================================================================
    // private methods.
    //=============================================================================================
    /* NOTHING */
};

} // namespace fnd

//-------------------------------------------------------------------------------------------------
// Inline Files
//-------------------------------------------------------------------------------------------------
#include <fndLfuCache.inl>

