﻿//-------------------------------------------------------------------------------------------------
// File : rsResMotion.h
// Desc : Motion Resource.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <vector>
#include <fndMath.h>


namespace rs {

///////////////////////////////////////////////////////////////////////////////////////////////////
// ResMorphKey structure
///////////////////////////////////////////////////////////////////////////////////////////////////
struct ResMorphKey
{
    double      Time;       //!< フレーム
    uint32_t    Index;      //!< モーフメッシュ番号です.
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// ResMorphAnimation structure
///////////////////////////////////////////////////////////////////////////////////////////////////
struct ResMorphAnimation
{
    std::string                 Tag;            //!< タグです.
    std::vector<ResMorphKey>    Keyframe;       //!< キーフレームです.
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// ResNodeKey structure
///////////////////////////////////////////////////////////////////////////////////////////////////
struct ResNodeKey
{
    double      Time;           //!< フレーム番号です.
    fnd::Matrix Transform;      //!< 変換行列です.
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// ResNodeAnimation structure
///////////////////////////////////////////////////////////////////////////////////////////////////
struct ResNodeAnimation
{
    std::string                 BoneTag;    //!< ボーンタグです.
    std::vector<ResNodeKey>     Keyframe;   //!< キーフレームデータです.
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// ResMotion structure
///////////////////////////////////////////////////////////////////////////////////////////////////
struct ResMotion
{
    std::string                     Tag;            //!< タグです.
    double                          Duration;       //!< 再生フレーム時間です.
    std::vector<ResNodeAnimation>   Node;           //!< ノードアニメーションデータです.
    std::vector<ResMorphAnimation>  Morph;          //!< モーフアニメーションデータです.
};

//-------------------------------------------------------------------------------------------------
//! @brief      モーションリソースを読み込みます.
//!
//! @param[in]      filename        ファイルパスです.
//! @param[out]     resource        リソースの格納先です.
//! @retval true    読み込みに成功.
//! @retval false   読み込みに失敗.
//-------------------------------------------------------------------------------------------------
bool LoadResMotion(const char* filename, std::vector<ResMotion>& resource);

//-------------------------------------------------------------------------------------------------
//! @brief      モーションリソースを書き込みます.
//!
//! @param[in]      filename        ファイルパスです.
//! @param[in]      resource        書き出すリソースです.
//! @retval true    書き込みに成功.
//! @retval false   書き込みに失敗.
//-------------------------------------------------------------------------------------------------
bool SaveResMotion(const char* filename, const std::vector<ResMotion>& resource);

} // namespace rs

