//=========================================================================
//	CScene3DNX
//	쐬:
//	쐬:2017/04/20
//=========================================================================
//=========================================================================
//	CN[ht@C
//=========================================================================
#include	"scene3D.h"
#include	"renderer.h"
#include	"manager.h"
#include	"camera.h"
#include	"light.h"

//=========================================================================
//	萔`
//=========================================================================
//eNX`̖O
#define	TEXTURE_NAME	("data/TEXTURE/akira000.png")
//_
#define NUM_VERTEX (4)
//|S
#define NUM_POLYGON (2)

//=========================================================================
// RXgN^
//=========================================================================
CScene3D::CScene3D()
{
	SetPosition( D3DXVECTOR3( 0.0f , 8.0f , 0.0f ) );
}

//=========================================================================
// fXgN^
//=========================================================================
CScene3D::~CScene3D()
{

}

//=========================================================================
// 
//=========================================================================
void CScene3D::Init( void )
{
	//foCX̎擾
	LPDIRECT3DDEVICE9	pDevice;
	pDevice = CRenderer::GetDevice();

	// eNX`̓ǂݍ
	if( FAILED( D3DXCreateTextureFromFile( pDevice , TEXTURE_NAME , &m_pTexture ) ) )
	{	//FALED}N@s𔻒f
		//eNX`ǂݍ߂ȂERRORMessage
		UINT nID = MessageBox( NULL , "eNX`܂\n" , "[ scene3D.cpp ] ERROR" , MB_OK | MB_ICONEXCLAMATION );		
	}

	//_obt@̐
	if( FAILED(pDevice->CreateVertexBuffer( sizeof(VERTEX_3D) * NUM_VERTEX , //mۂobt@TCY(byte)
											D3DUSAGE_WRITEONLY , //̎gp@  Ƃ肠ꂾĂΑ@G`̂
											FVF_VERTEX_3D , //gp钸_tH[}bg ł͂Oőv
											D3DPOOL_MANAGED , //obt@̊Ǘ@@̂͂܂̂
											&m_pVtxBuffer , //|C^̊i[
											NULL ))) //Ȃ񂾂킩Ȃ)
	{										
		UINT nID = MessageBox( NULL , "_obt@ł܂\n" , "[ scene3D.cpp ] ERROR" , MB_OK | MB_ICONEXCLAMATION );		
		//return E_FAIL;
	}

	//_̃Zbg
	SetVertex( pDevice );
}

//=========================================================================
// I
//=========================================================================
void CScene3D::Uninit( void )
{
	// eNX`̔j
	if( m_pTexture != NULL )
	{
		m_pTexture->Release();
		m_pTexture = NULL;
	}

	//_obt@̔j
	if( m_pVtxBuffer != NULL )
	{
		m_pVtxBuffer->Release();
		m_pVtxBuffer = NULL;
	}

}

//=========================================================================
// XV
//=========================================================================
void CScene3D::Update( void )
{

}

//=========================================================================
// `揈
//=========================================================================
void CScene3D::Draw( void )
{
	LPDIRECT3DDEVICE9	pDevice;
	pDevice = CRenderer::GetDevice();

	//[h}gNX̍쐬
	D3DXMATRIX	mtxWorld , mtxRot;
	//SSsNX

	//Pʍs̍쐬
	D3DXMatrixIdentity( &mtxWorld );	//sPʍsɂ
	
	//g̏
	D3DXMATRIX	mtxKakudai;	//gs
	D3DXMatrixScaling( &mtxKakudai , 3.0f , 3.0f , 3.0f );

	//]̏
	D3DXMATRIX	mtxKaiten;	//]s
	D3DXMatrixRotationYawPitchRoll( &mtxKaiten , 0.0f , D3DXToRadian( 90.0f ) , 0.0f );	
	
	D3DXMATRIX	mtxHeikou;	//sړs
	D3DXMatrixTranslation( &mtxHeikou , GetPosition().x , GetPosition().y , GetPosition().z );

	//s̊|Z
	D3DXMatrixMultiply( &mtxWorld , &mtxWorld , &mtxKakudai );	
	D3DXMatrixMultiply( &mtxWorld , &mtxWorld , &mtxKaiten );	
	D3DXMatrixMultiply( &mtxWorld , &mtxWorld , &mtxHeikou );	

	//foCXɃ[hϊso^
	pDevice->SetTransform( D3DTS_WORLD , &mtxWorld );

	//r[s̍쐬
	D3DXMATRIX	mtxView = CManager::GetCamera()->GetView();

	//foCXɃr[ϊsݒ
	pDevice->SetTransform( D3DTS_VIEW , &mtxView);

	pDevice->SetLight( 0, &CManager::GetLight()->GetLight() );

	pDevice->SetStreamSource( 0 , m_pVtxBuffer , 0 , sizeof(VERTEX_3D) );

	pDevice->SetFVF( FVF_VERTEX_3D );

	pDevice->SetTexture( 0,  m_pTexture );

	//|S̕`
	pDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP , 0 , NUM_POLYGON );

}

//=========================================================================
//	_̐ݒ
//=========================================================================
HRESULT	CScene3D::SetVertex( LPDIRECT3DDEVICE9 pDevice )
{
	//VERTEX_2D^̃|C^
	VERTEX_3D* pVtx = NULL;

	//obt@bNzAhX擾
	m_pVtxBuffer->Lock( 0 , 0 , (void**)&pVtx ,0 );	//̍ŏQɂOOw肷ƑS


	//_W̐ݒ				 X		   Y		Z
	pVtx[0].pos = D3DXVECTOR3(  -1.31f ,  2.5f , 0.0f);
	pVtx[1].pos = D3DXVECTOR3(  1.31f ,  2.5f , 0.0f);
	pVtx[2].pos = D3DXVECTOR3(  -1.31f , -2.5f  , 0.0f);
	pVtx[3].pos = D3DXVECTOR3( 1.31f , -2.5f , 0.0f);

	//@
	pVtx[0].normal = D3DXVECTOR3(  0.0f , 0.0f , -1.0f );
	pVtx[1].normal = D3DXVECTOR3(  0.0f , 0.0f , -1.0f );
	pVtx[2].normal = D3DXVECTOR3(  0.0f , 0.0f , -1.0f );
	pVtx[3].normal = D3DXVECTOR3(  0.0f , 0.0f , -1.0f );

	//_Eݒ
	pVtx[0].color = D3DCOLOR_RGBA( 255, 255 , 255  , 255); 
	pVtx[1].color = D3DCOLOR_RGBA( 255, 255 , 255  , 255); 
	pVtx[2].color = D3DCOLOR_RGBA( 255, 255 , 255  , 255); 
	pVtx[3].color = D3DCOLOR_RGBA( 255, 255 , 255  , 255); 

	//eNX`W
	pVtx[0].tex = D3DXVECTOR2( 0.0f, 0.0f );
	pVtx[1].tex = D3DXVECTOR2( 1.0f, 0.0f );
	pVtx[2].tex = D3DXVECTOR2( 0.0f, 1.0f );
	pVtx[3].tex = D3DXVECTOR2( 1.0f, 1.0f );

	m_pVtxBuffer->Unlock();

	return	S_OK;
}

/**********************************EOF***************************************/