<?php
/*++++++++++++++++++++++++++++++++++++++++++++++++++++
| LightNEasy Content Management System
| Copyright 2007 - 2010 Fernando Baptista
| http://www.Lightneasy.org
++++++++++++++++++++++++++++++++++++++++++++++++++++++
| common.php common functions module
| no database Version 2.4
++++++++++++++++++++++++++++++++++++++++++++++++++++++
| Released under the terms & conditions of v2 of the
| GNU General Public License. For details refer to
| the included gpl.txt file or visit http://gnu.org
++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
$myserver=$_SERVER['SERVER_NAME'];

// LightNEasy version
$LNEversion="2.4";
$fuso_s = strval($set['timeoffset']) * 3600;
//read the addons table
$addons=readdata("addons");

function clean($string) {
	return trim(str_replace('&nbsp;',' ',$string));
}

function compare($x,$y) {
	if($x[0] == $y[0]) return 0;
	elseif($x[0] < $y[0]) return -1;
	else return 1;
}

function data_formatada($unix_time) {
	global $set;
	return strftime($set['dateformat'], $unix_time);
}

function decode($string) {
	return utf8_decode(stripslashes($string));
}

function encode($string) {
	return addslashes(utf8_encode($string));
}

function filelist($pattern, $start_dir='.', $dir=0) {
$filenames=array();
if ($handle = opendir($start_dir)) {
	while (false !== ($file = readdir($handle))) {
		if (strcmp($file, '.')==0 || strcmp($file, '..')==0) continue;
		if($dir) {
			if(is_dir($start_dir."/".$file))
				array_push($filenames, $file);
		} else
			array_push($filenames, $file);
	}
	closedir($handle);
}
$order=-1;
$filesort = create_function('$a,$b', "\$a1=\$a$sortby;\$b1=\$b$sortby; if (\$a1==\$b1) return 0; else return (\$a1<\$b1) ? -1 : 1;");
uasort($filenames, $filesort);
return $filenames;
}

function fullmenu($generat=0) {
       global $pagenum, $menu, $selected, $extension, $set;
       $count=0;
       $out="\n";
       while($menu[$count][0] != "") {
// Bugfix by Jochen Wendel:
               if(strpos($menu[$count][3],"#") === false && $menu[$count][0] != "0") {
               $out.='<li';
               if($menu[$count][2]!="0")
                       $out.=" class=\"LNE_menu_doubleintend\"";
               elseif($menu[$count][1]!="0")
                       $out.=" class=\"LNE_menu_intend\"";
               else
                       $out.=" class=\"LNE_menu\"";
               $out.="><a ";
               if($menu[$count][4]==$selected['name'])
                       $out.= 'class="selected" ';
               if(strpos($menu[$count][3],"*"))
                       $out.='href="'.str_replace("*", "",$menu[$count][3]).'">';
               elseif($generat)
                       $out.='href="'.$menu[$count][3].".".$set['extension'].'">';
               else
                       $out.='href="'.$set['indexfile'].'?page='.$menu[$count][3].'">';
               $out.=$menu[$count][4]."</a></li>\n";
               }
               $count++;
       }
       return $out;
}

function is_intval($value) {
     return 1 === preg_match('/^[+-]?[0-9]+$/', $value);
}

function loginform() {
	global $langmessage, $LNEversion;
	$out='<div align="center"><form method="post" action=""><h2>LightNEasy '.$LNEversion.' '.$langmessage[120].'</h2>';
	$out.='<p>'.$langmessage[6].':&nbsp;<input  type="password" name="password" value="" />';
	$out.='<input type="hidden" name="submit" value="Login" />';
	$out.='<input type="submit" name="aa" value="'.$langmessage[120].'" /></p></form></div>';
	return $out;
}

function readdata($file){
	// read a data file, returns an array with the content
	$content=@file_get_contents("data/".$file.".dat");
	str_replace("||\n", "||", $content);
	$aa=array();
	$aa = explode("||",trim($content));
	$count = 0;
	foreach($aa as $aaa) {
		$bb[$count] = explode("|",trim($aaa));
		$count++;
	}
	return $bb;
}

function readmenu() {
	//Read menu
	global $menu, $pagenum,$selected;
	$aaa=decode(trim(file_get_contents("data/menu.dat")));
	array($menu);
	unset($mmenu);
	$mmenu=explode("||",$aaa);
	$count=0;
	foreach($mmenu as $mmmenu) {
		$menu[$count]=explode("|",trim($mmmenu));
		$menu[$count][4]=decode($menu[$count][4]);
		if($menu[$count][3]==$pagenum) {
			$selected['index']=$menu[$count][0];
			$selected['name']=$menu[$count][4];
		}
		$count++;
	}
	//Read page data
	$aaa=trim(decode(file_get_contents("data/pages.dat")));
	$pag=array();
	$pag=explode("||",$aaa);
	$selected['descr']="-";
	$selected['template']="-";
	foreach($pag as $ppag) {
		$page=array();
		$page=explode("|",trim($ppag));
		$count=0;
		while($menu[$count][0] !="") {
			if($menu[$count][3] == trim($page[0])) {
				$menu[$count][5] = trim($page[1]);
				$menu[$count][6] = trim($page[2]);
				if($menu[$count][4]==$selected['name']) {
					$selected['descr'] = $page[1];
					$selected['template'] = $page[2];
					break;
				}
			}
			$count++;
		}
	}
//print_r($menu);
}

function readsetup() {
	global $set, $langmessage;
	require "data/config.php";
	$set['title']=decode($set['title']);
	$set['subtitle']=decode($set['subtitle']);
	$set['keywords']=decode($set['keywords']);
	$set['description']=decode($set['description']);
	$set['author']=decode($set['author']);
	$set['footer']=decode($set['footer']);
	$set['extension']="php";
	if($set['language']=="") $set['language']="en_US";
	if($set['langeditor']=="") $set['langeditor']="en";
	require "./languages/lang_".$set['language'].".php";
}

function sanitize($text) {
	// Convert problematic ascii characters to their true values
	$search = array("40","41","58","65","66","67","68","69","70",
		"71","72","73","74","75","76","77","78","79","80","81",
		"82","83","84","85","86","87","88","89","90","97","98",
		"99","100","101","102","103","104","105","106","107",
		"108","109","110","111","112","113","114","115","116",
		"117","118","119","120","121","122"
		);
	$replace = array("(",")",":","a","b","c","d","e","f","g","h",
		"i","j","k","l","m","n","o","p","q","r","s","t","u",
		"v","w","x","y","z","a","b","c","d","e","f","g","h",
		"i","j","k","l","m","n","o","p","q","r","s","t","u",
		"v","w","x","y","z"
		);
	$entities = count($search);
	for ($i=0;$i < $entities;$i++) $text = preg_replace("#(&\#)(0*".$search[$i]."+);*#si", $replace[$i], $text);
	// the following is based on code from bitflux (http://blog.bitflux.ch/wiki/)
	// Kill hexadecimal characters completely
	$text = preg_replace('#(&\#x)([0-9A-F]+);*#si', "", $text);
	// remove any attribute starting with "on" or xmlns
	$text = preg_replace('#(<[^>]+[\\"\'\s])(onmouseover|onmousedown|onmouseup|onmouseout|onmousemove|onclick|ondblclick|onload|xmlns)[^>]*>#iU', ">", $text);
	do {
		$oldtext = $text;
		preg_replace('#</*(applet|meta|xml|blink|link|style|script|embed|object|iframe|frame|frameset|ilayer|layer|bgsound|title|base)[^>]*>#i', "", $text);
	// remove javascript: and vbscript: protocol
	} while ($oldtext != $text);
	$text = preg_replace('#([a-z]*)=([\`\'\"]*)script:#iU', '$1=$2nojscript...', $text);
	$text = preg_replace('#([a-z]*)=([\`\'\"]*)javascript:#iU', '$1=$2nojavascript...', $text);
	$text = preg_replace('#([a-z]*)=([\'\"]*)vbscript:#iU', '$1=$2novbscript...', $text);
	$text = preg_replace('#(<[^>]+)style=([\`\'\"]*).*expression\([^>]*>#iU', "$1>", $text);
	$text = preg_replace('#(<[^>]+)style=([\`\'\"]*).*behaviour\([^>]*>#iU', "$1>", $text);
	return $text;
}

function sv($s) {
	if (!isset($_SERVER)) {
		global $_SERVER;
		$_SERVER = $GLOBALS['HTTP_SERVER_VARS'];
	}
	if (isset($_SERVER[$s]))return $_SERVER[$s];
	else return'';
}

//replacement for PHP5 function http_build_query() if that function doesn't exist
//taken from the PHP online manual
if(!function_exists('http_build_query')) {
    function http_build_query($data,$prefix=null,$sep='',$key='') {
        $ret    = array();
            foreach((array)$data as $k => $v) {
                $k    = urlencode($k);
                if(is_int($k) && $prefix != null) {
                    $k    = $prefix.$k;
                };
                if(!empty($key)) {
                    $k    = $key."[".$k."]";
                };

                if(is_array($v) || is_object($v)) {
                    array_push($ret,http_build_query($v,"",$sep,$k));
                }
                else {
                    array_push($ret,$k."=".urlencode($v));
                };
            };

        if(empty($sep)) {
            $sep = ini_get("arg_separator.output");
        };

        return    implode($sep, $ret);
    };
};

?>