// ԔaNX

#include <iomanip>
#include <sstream>
#include <random>
#include <cstdlib>
#include <cmath>
#include "lilib.h"

using namespace std;
using namespace lilib;

// *this = |a / b|
void Radius::div(const LongFloat &a, const LongFloat &b){
  LongFloat a2, b2;
  volatile double doubleA, doubleB, r;
  int exponentA, exponentB, roundOld;

  exponentA = a.exponent;
  exponentB = b.exponent;

  a2 = a;
  b2 = b;
  a2.sign = 1;
  b2.sign = 1;
  a2.exponent = 0;
  b2.exponent = 0;

  doubleA = a2.getDouble(1);
  doubleB = b2.getDouble(-1);

  roundOld = getRound();
  setRound(1);
  r = doubleA / doubleB;
  setRound(roundOld);

  *this = Radius(r);
  exponent += (exponentA - exponentB) * LIMB_BITS;
}

////////////////////////////////////////////////////////////////////////////////

// RXgN^
Radius::Radius(){
}

// RXgN^
Radius::Radius(uint32_t significand, int exponent){

  // 𐳋KB
  if(significand){
    while(!(significand & 0x80000000)){
      significand <<= 1;
      exponent--;
    }
  }

  //  0 ȂAw 0 ɂB
  else{
    exponent = 0;
  }

  this->significand = significand;
  this->exponent = exponent;
}

// RXgN^
Radius::Radius(double x){
  binary64 tmp;
  int e;
  uint64_t f;

  tmp.d = x;

  // double l̎wEoB
  e = (tmp.i >> 52) & 0x7ff;
  f = tmp.i & 0xfffffffffffffLL;

  if(e == 2047){
    cerr << "[ERROR] Radius::Radius(double) : Invalid value." << endl;
    exit(1);
  }

  // K
  if(e){
    e -= 1023;
    f = (f + 0x10000000000000LL) << 11;

    significand = high32(f);
    exponent = e - LIMB_BITS + 1;

    *this += Radius(low32(f), e - 2 * LIMB_BITS + 1);
  }

  // 񐳋K
  else{
    f <<= 12;

    *this = Radius(high32(f), -LIMB_BITS - 1022);
    *this += Radius(low32(f), -2 * LIMB_BITS - 1022);
  }
}

// Rs[RXgN^
Radius::Radius(const Radius &x){
  significand = x.significand;
  exponent = x.exponent;
}

// RXgN^
Radius::Radius(const LongFloat &x){
  int i;

  significand = 0;
  exponent = 0;

  for(i = limbs - 1; i >= 0; i--){
    *this += Radius(x.limb[i], LIMB_BITS * (x.exponent - i));
  }
}

// fXgN^
Radius::~Radius(){
}

////////////////////////////////////////////////////////////////////////////////

// double ւ̕ϊ
double Radius::getDouble() const{
  binary64 x;

  // 0 ̏ꍇ
  if(significand == 0){
    return 0;
  }

  if((exponent < -1053) || (992 < exponent)){
    cerr << "[ERROR] Radius::getDouble() : Invalid value." << endl;
    exit(1);
  }

  x.i = exponent + 1054;
  x.i <<= 31;
  x.i |= significand & 0x7fffffff;
  x.i <<= 21;

  return x.d;
}

// ւ̕ϊ
string Radius::getString() const{
  ostringstream output;
  double a, f;
  int e;

  if(significand){

    // a = log10(significand) + log10(2) * exponent;
    a = log10(static_cast<double>(significand)) + 0.30102999566398119521 * exponent;

    e = static_cast<int>(floor(a));
    f = pow(10, a - e);

    if(f >= 10){
      f /= 10;
      e++;
    }

    output << fixed << f;

    if(e){
      output << "e" << e;
    }
  }
  else{
    output << fixed << 0.0;
  }

  return output.str();
}

// f[^\̎擾
string Radius::getInternalData() const{
  ostringstream output;

  output << "(" << hex << setw(8) << setfill('0') << significand;
  output << ", " << dec << exponent << ")";

  return output.str();
}

////////////////////////////////////////////////////////////////////////////////

// l𗐐ɂ(eXgp)
void Radius::random(int exponentMin, int exponentMax){
  random_device rnd;
  uniform_int_distribution<> randomExponent(exponentMin, exponentMax);

  significand = rnd() | 0x80000000;
  exponent = randomExponent(rnd);
}

// lZ
////////////////////////////////////////////////////////////////////////////////

// Radius * int
Radius Radius::operator *(int x) const{
  Radius result;
  uint64_t work;
  uint32_t h;

  // ʂ 0 ̏ꍇ
  if((significand == 0) || (x == 0)){
    result.significand = 0;
    result.exponent = 0;

    return result;
  }

  if(x < 0){
    x = -x;
  }

  // Z
  work = significand;
  work *= x;

  // K
  result.exponent = exponent - normalize64(&work) + LIMB_BITS;

  //  32 rbgۂ߂B
  if(low32(work)){
    h = high32(work);
    if(h == 0xffffffff){
      result.significand = 0x80000000;
      result.exponent++;
    }
    else{
      result.significand = h + 1;
    }
  }
  else{
    result.significand = high32(work);
  }

  return result;
}

// Radius / int
Radius Radius::operator /(int x) const{
  Radius result;
  uint64_t work, quotient;
  uint32_t h;

  if(x == 0){
    cerr << "[ERROR] Radius / int : Division by zero." << endl;
    exit(1);
  }

  if(x < 0){
    x = -x;
  }

  work = significand;
  work <<= LIMB_BITS;

  // Z
  quotient = work / x;
  if(work - x * quotient){
    work = quotient + 1;
  }
  else{
    work = quotient;
  }

  // K
  result.exponent = exponent - normalize64(&work);

  //  32 rbgۂ߂B
  if(low32(work)){
    h = high32(work);
    if(h == 0xffffffff){
      result.significand = 0x80000000;
      result.exponent++;
    }
    else{
      result.significand = h + 1;
    }
  }
  else{
    result.significand = high32(work);
  }

  return result;
}

// Radius + Radius
Radius Radius::operator +(const Radius &x) const{
  Radius result;
  uint64_t a, b;
  uint32_t h;

  // x == 0 ȂA this ԂB
  if(x.significand == 0){
    result.significand = significand;
    result.exponent = exponent;

    return result;
  }

  // this == 0 ȂA x ԂB
  if(significand == 0){
    result.significand = x.significand;
    result.exponent = x.exponent;

    return result;
  }

  // this >> x ȂA this + 1 ԂB
  if(exponent >= x.exponent + LIMB_BITS){
    if(significand == 0xffffffff){
      result.significand = 0x80000000;
      result.exponent = exponent + 1;
    }
    else{
      result.significand = significand + 1;
      result.exponent = exponent;
    }

    return result;
  }

  // this << x ȂA x + 1 ԂB
  if(exponent + LIMB_BITS <= x.exponent){
    if(x.significand == 0xffffffff){
      result.significand = 0x80000000;
      result.exponent = x.exponent + 1;
    }
    else{
      result.significand = x.significand + 1;
      result.exponent = x.exponent;
    }

    return result;
  }

  // this ̎w̕傫A܂͓Ƃ
  if(exponent >= x.exponent){
    a = significand;
    a <<= LIMB_BITS - 1;

    b = x.significand;
    b <<= x.exponent - exponent + LIMB_BITS - 1;

    a += b;

    // K
    result.exponent = exponent - normalize64(&a) + 1;

    //  32 rbgۂ߂B
    if(low32(a)){
      h = high32(a);
      if(h == 0xffffffff){
        result.significand = 0x80000000;
        result.exponent++;
      }
      else{
        result.significand = h + 1;
      }
    }
    else{
      result.significand = high32(a);
    }

    return result;
  }

  // x ̎w̕傫Ƃ
  a = significand;
  a <<= exponent - x.exponent + LIMB_BITS - 1;

  b = x.significand;
  b <<= LIMB_BITS - 1;

  a += b;

  // K
  result.exponent = x.exponent - normalize64(&a) + 1;

  //  32 rbgۂ߂B
  if(low32(a)){
    h = high32(a);
    if(h == 0xffffffff){
      result.significand = 0x80000000;
      result.exponent++;
    }
    else{
      result.significand = h + 1;
    }
  }
  else{
    result.significand = high32(a);
  }

  return result;
}

// Radius * Radius
Radius Radius::operator *(const Radius &x) const{
  Radius result;
  uint64_t work;
  uint32_t h;

  // ʂ 0 ̏ꍇ
  if((significand == 0) || (x.significand == 0)){
    result.significand = 0;
    result.exponent = 0;

    return result;
  }

  // Z
  work = significand;
  work *= x.significand;

  // K
  result.exponent = exponent + x.exponent - normalize64(&work) + LIMB_BITS;

  //  32 rbgۂ߂B
  if(low32(work)){
    h = high32(work);
    if(h == 0xffffffff){
      result.significand = 0x80000000;
      result.exponent++;
    }
    else{
      result.significand = h + 1;
    }
  }
  else{
    result.significand = high32(work);
  }

  return result;
}

// rZ
////////////////////////////////////////////////////////////////////////////////

// Radius == Radius
bool Radius::operator ==(const Radius &x) const{
  return (significand == x.significand) && (exponent == x.exponent);
}

// Radius != Radius
bool Radius::operator !=(const Radius &x) const{
  return !(*this == x);
}

// Z
////////////////////////////////////////////////////////////////////////////////

// Radius *= int
Radius &Radius::operator *=(int x){
  *this = *this * x;

  return *this;
}

// Radius /= int
Radius &Radius::operator /=(int x){
  *this = *this / x;

  return *this;
}

// Radius = Radius
Radius &Radius::operator =(const Radius &x){
  significand = x.significand;
  exponent = x.exponent;

  return *this;
}

// Radius += Radius
Radius &Radius::operator +=(const Radius &x){
  *this = *this + x;

  return *this;
}

// Radius *= Radius
Radius &Radius::operator *=(const Radius &x){
  *this = *this * x;

  return *this;
}

// lZith֐j
////////////////////////////////////////////////////////////////////////////////

// int * Radius
Radius operator *(int a, const Radius &b){
  return b * a;
}

////////////////////////////////////////////////////////////////////////////////

// std::ostream << Radius
ostream &operator <<(ostream &output, const Radius &x){
  output << x.getString();

  return output;
}
