%global gname haclient
%global uname hacluster
%global pcmk_docdir %{_docdir}/%{name}

%global specversion 1
%global upstream_version f1e0560
%global upstream_prefix ClusterLabs-pacemaker

# Compatibility macros for distros (fedora) that don't provide Python macros by default
# Do this instead of trying to conditionally %include %{_rpmconfigdir}/macros.python
%{!?py_ver:     %{expand: %%global py_ver      %%(echo `python -c "import sys; print sys.version[:3]"`)}}
%{!?py_prefix:  %{expand: %%global py_prefix   %%(echo `python -c "import sys; print sys.prefix"`)}}
%{!?py_libdir:  %{expand: %%global py_libdir   %%{expand:%%%%{py_prefix}/%%%%{_lib}/python%%%%{py_ver}}}}
%{!?py_sitedir: %{expand: %%global py_sitedir  %%{expand:%%%%{py_libdir}/site-packages}}}

# Compatibility macro wrappers for legacy RPM versions that do not
# support conditional builds
%{!?bcond_without: %{expand: %%global bcond_without() %%{expand:%%%%{!?_without_%%{1}:%%%%global with_%%{1} 1}}}}
%{!?bcond_with:    %{expand: %%global bcond_with()    %%{expand:%%%%{?_with_%%{1}:%%%%global with_%%{1} 1}}}}
%{!?with:          %{expand: %%global with()          %%{expand:%%%%{?with_%%{1}:1}%%%%{!?with_%%{1}:0}}}}
%{!?without:       %{expand: %%global without()       %%{expand:%%%%{?with_%%{1}:0}%%%%{!?with_%%{1}:1}}}}

# Conditionals
# Invoke "rpmbuild --without <feature>" or "rpmbuild --with <feature>"
# to disable or enable specific features
%bcond_without ais
%bcond_without heartbeat
# ESMTP is not available in RHEL, only in EPEL. Allow people to build
# the RPM without ESMTP in case they choose not to use EPEL packages
%bcond_without esmtp
%bcond_without snmp

# Use a different versioning scheme
%bcond_with pre_release

%if %{with pre_release}
%global pcmk_release 0.%{specversion}.%{upstream_version}.hg
%else
%global pcmk_release %{specversion}
%endif

Name:		pacemaker
Summary:	Scalable High-Availability cluster resource manager
Version:	1.0.12
#Release:	%{pcmk_release}%{?dist}
Release:	1.el5
License:	GPLv2+ and LGPLv2+
Url:		http://www.clusterlabs.org
Group:		System Environment/Daemons
Source0:	%{upstream_prefix}-%{?upstream_version}.tar.bz2
BuildRoot:	%(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)
AutoReqProv:	on
Requires(pre):	cluster-glue
Requires:	resource-agents
Requires:	python >= 2.4
Conflicts:      heartbeat < 2.99
Requires:	pacemaker-libs = %{version}-%{release}

%if 0%{?fedora} || 0%{?centos} > 4 || 0%{?rhel} > 4
Requires:       perl(:MODULE_COMPAT_%(eval "`%{__perl} -V:version`"; echo $version))
BuildRequires:  help2man libtool-ltdl-devel
%endif

%if 0%{?suse_version}
# net-snmp-devel on SLES10 does not suck in tcpd-devel automatically
BuildRequires:  help2man tcpd-devel
%endif

# Required for core functionality
BuildRequires:  automake autoconf libtool pkgconfig
BuildRequires:	glib2-devel cluster-glue-libs-devel libxml2-devel libxslt-devel 
BuildRequires:	pkgconfig python-devel gcc-c++ bzip2-devel gnutls-devel pam-devel libtool-ltdl-devel

# Enables optional functionality
BuildRequires:	ncurses-devel openssl-devel libselinux-devel

%ifarch alpha %{ix86} x86_64
BuildRequires:  lm_sensors-devel
%endif

%if %{with esmtp}
BuildRequires:	libesmtp-devel
%endif

%if %{with snmp}
BuildRequires:	net-snmp-devel
%endif

%if %{with ais}
BuildRequires:	corosynclib-devel
%endif

%if %{with heartbeat}
BuildRequires:	heartbeat-devel heartbeat-libs
%endif

%description
Pacemaker is an advanced, scalable High-Availability cluster resource
manager for Linux-HA (Heartbeat) and/or OpenAIS.

It supports "n-node" clusters with significant capabilities for
managing resources and dependencies.

It will run scripts at initialization, when machines go up or down,
when related resources fail and can be configured to periodically check
resource health.

Available rpmbuild rebuild options:
  --without : heartbeat ais esmtp snmp

%package -n pacemaker-libs
License:	GPLv2+ and LGPLv2+
Summary:	Libraries used by the Pacemaker cluster resource manager and its clients
Group:		System Environment/Daemons

%description -n pacemaker-libs
Pacemaker is an advanced, scalable High-Availability cluster resource
manager for Linux-HA (Heartbeat) and/or OpenAIS.

It supports "n-node" clusters with significant capabilities for
managing resources and dependencies.

It will run scripts at initialization, when machines go up or down,
when related resources fail and can be configured to periodically check
resource health.

%package -n pacemaker-libs-devel 
License:	GPLv2+ and LGPLv2+
Summary:	Pacemaker development package
Group:		Development/Libraries
Requires:	pacemaker-libs = %{version}-%{release}
Requires:	cluster-glue-libs-devel libtool-ltdl-devel
%if %{with ais}
Requires:	corosynclib-devel
%endif
%if %{with heartbeat}
Requires:	heartbeat-devel
%endif

%description -n pacemaker-libs-devel
Headers and shared libraries for developing tools for Pacemaker.

Pacemaker is an advanced, scalable High-Availability cluster resource
manager for Linux-HA (Heartbeat) and/or OpenAIS.

It supports "n-node" clusters with significant capabilities for
managing resources and dependencies.

It will run scripts at initialization, when machines go up or down,
when related resources fail and can be configured to periodically check
resource health.

%prep
%setup -q -n %{upstream_prefix}-%{?upstream_version}

%build
./autogen.sh

# RHEL <= 5 does not support --docdir
docdir=%{pcmk_docdir} %{configure} \
	%{!?with_heartbeat: --without-heartbeat}	\
	%{!?with_ais:       --without-ais}		\
	%{!?with_esmtp:     --without-esmtp}		\
	%{!?with_snmp:      --without-snmp}		\
	--localstatedir=%{_var} \
	--enable-fatal-warnings=no
make %{_smp_mflags} docdir=%{pcmk_docdir}

%install
rm -rf %{buildroot}
make DESTDIR=%{buildroot} docdir=%{pcmk_docdir} install

# Scripts that need should be executable
chmod a+x %{buildroot}/%{_libdir}/heartbeat/hb2openais-helper.py
chmod a+x %{buildroot}/%{_datadir}/pacemaker/tests/cts/CTSlab.py
chmod a+x %{buildroot}/%{_datadir}/pacemaker/tests/cts/extracttests.py

# These are not actually scripts
find %{buildroot} -name '*.xml' -type f -print0 | xargs -0 chmod a-x
find %{buildroot} -name '*.xsl' -type f -print0 | xargs -0 chmod a-x
find %{buildroot} -name '*.rng' -type f -print0 | xargs -0 chmod a-x
find %{buildroot} -name '*.dtd' -type f -print0 | xargs -0 chmod a-x
 
# Dont package static libs
find %{buildroot} -name '*.a' -type f -print0 | xargs -0 rm -f
find %{buildroot} -name '*.la' -type f -print0 | xargs -0 rm -f

# Do not package these either
rm %{buildroot}/%{_libdir}/heartbeat/crm_primitive.py
%if %{with ais}
rm %{buildroot}/%{_libdir}/service_crm.so
%endif

%clean
rm -rf %{buildroot}

%post -n pacemaker-libs -p /sbin/ldconfig

%postun -n pacemaker-libs -p /sbin/ldconfig

%files
###########################################################
%defattr(-,root,root)

%exclude %{_datadir}/pacemaker/tests
%{_datadir}/pacemaker
%{_datadir}/snmp/mibs/PCMK-MIB.txt
%{_libdir}/heartbeat/*
%{_sbindir}/cibadmin
%{_sbindir}/crm_attribute
%{_sbindir}/crm_diff
%{_sbindir}/crm_failcount
%{_sbindir}/crm_master
%{_sbindir}/crm_mon
%{_sbindir}/crm
%{_sbindir}/crm_resource
%{_sbindir}/crm_standby
%{_sbindir}/crm_verify
%{_sbindir}/crmadmin
%{_sbindir}/iso8601
%{_sbindir}/attrd_updater
%{_sbindir}/ptest
%{_sbindir}/crm_shadow
%{_sbindir}/cibpipe
%{_sbindir}/crm_node
%{py_sitedir}

%if %{with heartbeat}
%{_sbindir}/crm_uuid
%else
%exclude %{_sbindir}/crm_uuid
%endif

# Packaged elsewhere
%exclude %{pcmk_docdir}/AUTHORS
%exclude %{pcmk_docdir}/COPYING
%exclude %{pcmk_docdir}/COPYING.LIB

%doc %{pcmk_docdir}
%doc %{_mandir}/man8/*.8*
%doc COPYING
%doc AUTHORS

%dir %attr (750, %{uname}, %{gname}) %{_var}/lib/heartbeat/crm
%dir %attr (750, %{uname}, %{gname}) %{_var}/lib/pengine
%dir %attr (750, %{uname}, %{gname}) %{_var}/run/crm
%dir /usr/lib/ocf
%dir /usr/lib/ocf/resource.d
/usr/lib/ocf/resource.d/pacemaker
%if %{with ais}
%{_libexecdir}/lcrso/pacemaker.lcrso
%endif

%files -n pacemaker-libs
%defattr(-,root,root)
%{_libdir}/libcib.so.*
%{_libdir}/libcrmcommon.so.*
%{_libdir}/libcrmcluster.so.*
%{_libdir}/libpe_status.so.*
%{_libdir}/libpe_rules.so.*
%{_libdir}/libpengine.so.*
%{_libdir}/libtransitioner.so.*
%{_libdir}/libstonithd.so.*
%doc COPYING.LIB
%doc AUTHORS

%files -n pacemaker-libs-devel
%defattr(-,root,root)
%{_includedir}/pacemaker
%{_includedir}/heartbeat/fencing
%{_libdir}/*.so
%{_datadir}/pacemaker/tests
%doc COPYING.LIB
%doc AUTHORS

%changelog
* Wed Nov 23 2011 Andrew Beekhof <andrew@beekhof.net> 1.0.12-1
- Update source tarball to Git revision: 6118778
- Statistics:
  Changesets: 96
  Diff:       121 files changed, 8617 insertions(+), 988 deletions(-)

- See https://github.com/ClusterLabs/pacemaker-1.0/blob/master/ChangeLog for further details

* Fri Apr 29 2011 Andrew Beekhof <andrew@beekhof.net> 1.0.11-1
- Update source tarball to revision: bc6104efe006 (stable-1.0) tip
- Statistics:
  Changesets: 85
  Diff:       500 files changed, 69642 insertions(+), 58270 deletions(-)

- See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Fri Nov 12 2010 Andrew Beekhof <andrew@beekhof.net> 1.0.10-1
- Update source tarball to revision: 4172c2ad2756 (stable-1.0) tip
- Statistics:
  Changesets: 75
  Diff:       146 files changed, 4151 insertions(+), 2135 deletions(-)

- See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Wed Jun 23 2010 Andrew Beekhof <andrew@beekhof.net> 1.0.9.1-1
- Update source tarball to revision: c9a5915827d0 (stable-1.0) tip
- Statistics:
  Changesets: 4
  Diff:       2 files changed, 3 insertions(+), 1 deletion(-)

- See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Wed Jun 23 2010 Andrew Beekhof <andrew@beekhof.net> 1.0.9-1
- Update source tarball to revision: 0796085f3833+ (stable-1.0) tip
- Statistics:
  Changesets: 152
  Diff:       266 files changed, 14324 insertions(+), 3842 deletions(-)

- See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Thu Apr 15 2010 Andrew Beekhof <andrew@beekhof.net> - 1.0.8-6
- Rebuild for glue 1.0.5

* Thu Apr 15 2010 Andrew Beekhof <andrew@beekhof.net> - 1.0.8-5
- Rebuild for glue 1.0.4, agents 1.0.3, and heartbeat 3.0.3

* Thu Apr 08 2010 Andrew Beekhof <andrew@beekhof.net> - 1.0.8-4
- Rebuild for corosync 1.2.1

* Wed Apr 07 2010 Andrew Beekhof <andrew@beekhof.net> - 1.0.8-3
- Rebuild with correct 1.0.8 tarball

* Thu Mar 25 2010 Andrew Beekhof <andrew@beekhof.net> - 1.0.8-2
- Rebuild with correct net-snmp version requirements

* Wed Mar 10 2010 Andrew Beekhof <andrew@beekhof.net> - 1.0.8-1
- Update source tarball to revision: 6b3c8ac50a90 (stable-1.0) tip
- Statistics:
      Changesets: 181
      Diff        329 files changed, 22172 insertions(+), 12297 deletions(-)

- See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Wed Feb 10 2010 Andrew Beekhof <andrew@beekhof.net> - 1.0.7-4
- Rebuild for heartbeat 3.0.2-2

* Wed Feb 10 2010 Andrew Beekhof <andrew@beekhof.net> - 1.0.7-3
- Rebuild for cluster-glue 1.0.3

* Tue Jan 19 2010 Andrew Beekhof <andrew@beekhof.net> - 1.0.7-2
- Rebuild for corosync 1.2.0

* Mon Jan 18 2010 Andrew Beekhof <andrew@beekhof.net> - 1.0.7-1
- Update source tarball to revision: 2eed906f43e9 (stable-1.0) tip
- Statistics:
      Changesets:      193
      Diff:            220 files changed, 15933 insertions(+), 8782 deletions(-)

- See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Thu Oct 29 2009 Andrew Beekhof <andrew@beekhof.net> - 1.0.5-4
- Include the fixes from CoroSync integration testing
- Move the resource templates - they are not documentation
- Ensure documentation is placed in a standard location
- Exclude documentation that is included elsewhere in the package

- Update the tarball from upstream to version ee19d8e83c2a
  + See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Wed Oct 13 2009 Andrew Beekhof <andrew@beekhof.net> - 1.0.5-3
- Update the tarball from upstream to version 38cd629e5c3c
  + See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Fri Aug 21 2009 Tomas Mraz <tmraz@redhat.com> - 1.0.5-2.1
- rebuilt with new openssl

* Wed Aug 19 2009 Andrew Beekhof <andrew@beekhof.net> - 1.0.5-2
- Add versioned perl dependency as specified by
    https://fedoraproject.org/wiki/Packaging/Perl#Packages_that_link_to_libperl
- No longer remove RPATH data, it prevents us finding libperl.so and no other
  libraries were being hardcoded
- Compile in support for heartbeat
- Conditionally add heartbeat-devel and corosynclib-devel to the -devel requirements 
  depending on which stacks are supported

* Mon Aug 17 2009 Andrew Beekhof <andrew@beekhof.net> - 1.0.5-1
- Add dependency on resource-agents
- Use the version of the configure macro that supplies --prefix, --libdir, etc
- Update the tarball from upstream to version 462f1569a437 (Pacemaker 1.0.5 final)
  + See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Tue Aug 11 2009 Ville Skyttä <ville.skytta@iki.fi> - 1.0.5-0.7.c9120a53a6ae.hg
- Use bzipped upstream tarball.

* Wed Jul  29 2009 Andrew Beekhof <andrew@beekhof.net> - 1.0.5-0.6.c9120a53a6ae.hg
- Add back missing build auto* dependancies
- Minor cleanups to the install directive

* Tue Jul  28 2009 Andrew Beekhof <andrew@beekhof.net> - 1.0.5-0.5.c9120a53a6ae.hg
- Add a leading zero to the revision when alphatag is used

* Tue Jul  28 2009 Andrew Beekhof <andrew@beekhof.net> - 1.0.5-0.4.c9120a53a6ae.hg
- Incorporate the feedback from the cluster-glue review
- Realistically, the version is a 1.0.5 pre-release
- Use the global directive instead of define for variables
- Use the haclient/hacluster group/user instead of daemon
- Use the _configure macro
- Fix install dependancies

* Fri Jul  24 2009 Andrew Beekhof <andrew@beekhof.net> - 1.0.4-3
- Initial Fedora checkin
- Include an AUTHORS and license file in each package
- Change the library package name to pacemaker-libs to be more 
  Fedora compliant
- Remove execute permissions from xml related files
- Reference the new cluster-glue devel package name
- Update the tarball from upstream to version c9120a53a6ae
  + See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Tue Jul 14 2009 Andrew Beekhof <andrew@beekhof.net> - 1.0.4-2
- Reference authors from the project AUTHORS file instead of listing in description
- Change Source0 to reference the Mercurial repo
- Cleaned up the summaries and descriptions
- Incorporate the results of Fedora package self-review

* Thu Jun 04 2009 Andrew Beekhof <abeekhof@suse.de> - 1.0.4-1
- Update source tarball to revision: 1d87d3e0fc7f (stable-1.0)
- Statistics:
    Changesets:      209
    Diff:            266 files changed, 12010 insertions(+), 8276 deletions(-)
- See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Wed Apr 08 2009 Andrew Beekhof <abeekhof@suse.de> - 1.0.3-1
- Update source tarball to revision: b133b3f19797 (stable-1.0) tip
- Statistics:
    Changesets:      383
    Diff:            329 files changed, 15471 insertions(+), 15119 deletions(-)

- See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Mon Feb 16 2009 Andrew Beekhof <abeekhof@suse.de> - 1.0.2-1
- Update source tarball to revision: d232d19daeb9 (stable-1.0) tip
- Statistics:
    Changesets:      441
    Diff:            639 files changed, 20871 insertions(+), 21594 deletions(-)
- See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Tue Nov 18 2008 Andrew Beekhof <abeekhof@suse.de> - 1.0.1-1
- Update source tarball to revision: 6fc5ce8302ab (stable-1.0) tip
- Statistics:
    Changesets:      170
    Diff:            816 files changed, 7633 insertions(+), 6286 deletions(-)
- See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Thu Oct 16 2008 Andrew Beekhof <abeekhof@suse.de> - 1.0.0-1
- Update source tarball to revision: 388654dfef8f tip
- Statistics:
    Changesets:      261
    Diff:            3021 files changed, 244985 insertions(+), 111596 deletions(-)
- See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Mon Sep 22 2008 Andrew Beekhof <abeekhof@suse.de> - 0.7.3-1
- Update source tarball to revision: 33e677ab7764+ tip
- Statistics:
    Changesets:      133
    Diff:            89 files changed, 7492 insertions(+), 1125 deletions(-)
- See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Wed Aug 20 2008 Andrew Beekhof <abeekhof@suse.de> - 0.7.1-1
- Update source tarball to revision: f805e1b30103+ tip
- Statistics:
    Changesets:      184
    Diff:            513 files changed, 43408 insertions(+), 43783 deletions(-)
- See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Fri Jul 18 2008 Andrew Beekhof <abeekhof@suse.de> - 0.7.0-19
- Update source tarball to revision: 007c3a1c50f5 (unstable) tip
- Statistics:
    Changesets:      108
    Diff:            216 files changed, 4632 insertions(+), 4173 deletions(-)
- See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Wed Jun 25 2008 Andrew Beekhof <abeekhof@suse.de> - 0.7.0-1
- Update source tarball to revision: bde0c7db74fb tip
- Statistics:
    Changesets:      439
    Diff:            676 files changed, 41310 insertions(+), 52071 deletions(-)
- See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Thu Jun 19 2008 Andrew Beekhof <abeekhof@suse.de> - 0.6.5-1
- Update source tarball to revision: b9fe723d1ac5 tip
- Statistics:
    Changesets:      48
    Diff:            37 files changed, 1204 insertions(+), 234 deletions(-)
- See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Thu May 22 2008 Andrew Beekhof <abeekhof@suse.de> - 0.6.4-1
- Update source tarball to revision: 226d8e356924 tip
- Statistics:
    Changesets:       55
    Diff:             199 files changed, 7103 insertions(+), 12378 deletions(-)
- See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Wed Apr 23 2008 Andrew Beekhof <abeekhof@suse.de> - 0.6.3-1
- Update source tarball to revision: fd8904c9bc67 tip
- Statistics:
    Changesets:      117
    Diff:            354 files changed, 19094 insertions(+), 11338 deletions(-)
- See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Thu Feb 14 2008 Andrew Beekhof <abeekhof@suse.de> - 0.6.2-1
- Update source tarball to revision: 28b1a8c1868b tip
- Statistics:
    Changesets:    11
    Diff:          7 files changed, 58 insertions(+), 18 deletions(-)
- See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Tue Feb 12 2008 Andrew Beekhof <abeekhof@suse.de> - 0.6.1-1
- Update source tarball to revision: e7152d1be933 tip
- Statistics:
    Changesets:    25
    Diff:          37 files changed, 1323 insertions(+), 227 deletions(-)
- See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Mon Jan 14 2008 Andrew Beekhof <abeekhof@suse.de> - 0.6.0-2
- This is the first release of the Pacemaker Cluster Resource Manager formerly part of Heartbeat.
- For those looking for the GUI, mgmtd, CIM or TSA components, they are now found in
  the new pacemaker-pygui project.  Build dependancies prevent them from being
  included in Heartbeat (since the built-in CRM is no longer supported) and,
  being non-core components, are not included with Pacemaker.
- Update source tarball to revision: c94b92d550cf
- Statistics:
    Changesets:      347
    Diff:            2272 files changed, 132508 insertions(+), 305991 deletions(-)
- See http://hg.clusterlabs.org/pacemaker/stable-1.0/file/tip/ChangeLog for further details

* Mon Dec 10 2007 Andrew Beekhof <abeekhof@suse.de> - 0.6.0-1
- Initial opensuse package check-in
