﻿/*
 * Messaging.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Lib.AppUtil.
 *
 * Boare.Lib.AppUtil is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.AppUtil is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;
using System.IO;
using System.Windows.Forms;

namespace Boare.Lib.AppUtil {

    public static class Messaging {
        private static string s_lang = "";
        private static List<MessageBody> s_messages = new List<MessageBody>();
        
        public static string[] GetKeys( string lang ) {
            foreach ( MessageBody dict in s_messages ) {
                if ( lang == dict.lang ) {
                    List<string> list = new List<string>();
                    foreach ( string key in dict.list.Keys ) {
                        list.Add( key );
                    }
                    return list.ToArray();
                }
            }
            return null;
        }

        public static string[] GetRegisteredLanguage() {
            List<string> res = new List<string>();
            foreach ( MessageBody dict in s_messages ) {
                res.Add( dict.lang );
            }
            return res.ToArray();
        }

        public static string Language {
            get {
                if ( s_lang != "" ) {
                    return s_lang;
                } else {
                    s_lang = "en";
                    return s_lang;
                }
            }
            set {
                if ( value != "" ) {
                    s_lang = value;
                } else {
                    s_lang = "en";
                }
            }
        }

        /// <summary>
        /// 現在の実行ディレクトリにある言語設定ファイルを全て読込み、メッセージリストに追加します
        /// </summary>
        public static void LoadMessages() {
            string app_path = Application.StartupPath;
            DirectoryInfo current = new DirectoryInfo( app_path );
            s_messages.Clear();
#if DEBUG
            Console.WriteLine( "Messaging+LoadMessages()" );
#endif
            foreach ( FileInfo fi in current.GetFiles( "*.po" ) ) {
                string fname = fi.FullName;
#if DEBUG
                Console.WriteLine( "    fname=" + fname );
#endif
                AppendFromFile( fname );
            }
        }

        private static void SeparateEntryAndMessage( string source, out string entry, out string message ) {
            string line = source.Trim();
            entry = "";
            message = "";
            if ( line.Length <= 0 ) {
                return;
            }
            int index_space = line.IndexOf( ' ' );
            int index_dquoter = line.IndexOf( '"' );
            int index = Math.Min( index_dquoter, index_space );
            entry = line.Substring( 0, index );
            message = line.Substring( index_dquoter + 1 );
            message = message.Substring( 0, message.Length - 1 );
        }

        private static string ReadTillMessageEnd( StreamReader sr, string first_line, string entry, out string msg ) {
            msg = "";
            string line = first_line;
            bool entry_found = false;
            if ( line.StartsWith( entry ) ) {
                string dum, dum2;
                SeparateEntryAndMessage( line, out dum, out dum2 );
                msg += dum2;
            } else {
                while ( sr.Peek() >= 0 ) {
                    line = sr.ReadLine();
                    if ( line.StartsWith( "#" ) ) {
                        continue;
                    }
                    if ( line.StartsWith( entry ) ) {
                        string dum, dum2;
                        SeparateEntryAndMessage( line, out dum, out dum2 );
                        msg += dum2;
                        break;
                    }
                }
            }
            string ret = "";
            while ( sr.Peek() >= 0 ) {
                line = sr.ReadLine();
                if ( !line.StartsWith( "\"" ) ) {
                    msg = msg.Replace( "\\\"", "\"" );
                    msg = msg.Replace( "\\n", "\n" );
                    return line;
                }
                int index = line.LastIndexOf( "\"" );
                msg += line.Substring( 1, index - 1 );
            }
            msg = msg.Replace( "\\\"", "\"" );
            msg = msg.Replace( "\\n", "\n" );
            return line;
        }

        public static void AppendFromFile( string file ) {
            string lang = Path.GetFileNameWithoutExtension( file );
            /*if ( !ISO639.CheckValidity( lang ) ) {
                return;
            }*/
            Dictionary<string, string> dict = new Dictionary<string, string>();
            using ( StreamReader sr = new StreamReader( file ) ) {
                while ( sr.Peek() >= 0 ) {
                    string msgid;
                    string first_line = sr.ReadLine();
                    string last_line = ReadTillMessageEnd( sr, first_line, "msgid", out msgid );
                    string msgstr;
                    last_line = ReadTillMessageEnd( sr, last_line, "msgstr", out msgstr );
                    if ( msgid.Length > 0 && msgstr.Length > 0 ) {
                        if ( dict.ContainsKey( msgid ) ) {
                            dict[msgid] = msgstr;
                        } else {
                            dict.Add( msgid, msgstr );
                        }
                    }
                }
            }
            string[] ids = new string[dict.Keys.Count];
            string[] msgs = new string[ids.Length];
            int i = -1;
            foreach ( string id in dict.Keys ) {
                i++;
                ids[i] = id;
                msgs[i] = dict[ids[i]];
            }
            MessageBody mb = new MessageBody( lang, ids, msgs );
            s_messages.Add( mb );
        }

        public static string GetMessage( string id ) {
            if ( s_lang.Length <= 0 ) {
                s_lang = "en";
            }
            foreach ( MessageBody mb in s_messages ) {
                if ( mb.lang == s_lang ) {
                    if ( mb.list.ContainsKey( id ) ) {
                        return mb.list[id];
                    }
                }
            }
            return id;
        }
    }

}
