/*
 * MidiEvent.java
 * Copyright (c) 2008 kbinani
 *
 * This file is part of jp.sourceforge.lipsync.vsq.
 *
 * jp.sourceforge.lipsync.vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * jp.sourceforge.lipsync.vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package jp.sourceforge.lipsync.vsq;

public enum MidiEventType {
    /// <summary>
    /// channel = 0～15の値
    /// </summary>
    channel,
    /// <summary>
    /// note = 0～127の値
    /// </summary>
    note,
    /// <summary>
    /// dtime = 0～268,435,455 (0x0FFFFFFF)の値
    /// </summary>
    dtime,
    /// <summary>
    /// velocity = 0～127の値
    /// </summary>
    velocity,
    /// <summary>
    /// patch = 0～127の値
    /// </summary>
    patch,
    /// <summary>
    /// sequence = 0-65,535 (0xFFFF)の値
    /// </summary>
    sequence,
    /// <summary>
    /// text = 0byte以上のASCII文字列
    /// </summary>
    text,
    /// <summary>
    /// raw = 0byte以上のバイナリデータの文字列
    /// </summary>
    raw,
    /// <summary>
    /// pitch_wheel = -8192～8191 (0x1FFF)の値
    /// </summary>
    pitch_wheel,
    /// <summary>
    /// song_pos = 0～16,383 (0x3FFF)の値
    /// </summary>
    song_pos,
    /// <summary>
    /// song_number = 0～127の値
    /// </summary>
    song_number,
    /// <summary>
    /// tempo = マイクロ秒, 0～16,777,215 (0x00FFFFFF)の値
    /// </summary>
    tempo,
    time_signal,
    unknown,
    /// <summary>
    /// 勝手に追加。スイマセン
    /// </summary>
    parameter,
}
