/*
 * VsqCurveType.java
 * Copyright (c) 2008 kbinani
 *
 * This file is part of jp.sourceforge.lipsync.vsq.
 *
 * jp.sourceforge.lipsync.vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * jp.sourceforge.lipsync.vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package jp.sourceforge.lipsync.vsq;
/// <summary>
/// vsqファイルで編集可能なカーブ・プロパティの種類
/// </summary>

public enum VsqCurveType {
    /// <summary>
    /// ベロシティ
    /// </summary>
    VEL,
    /// <summary>
    /// ダイナミクス　64
    /// </summary>
    DYN,
    /// <summary>
    /// ブレシネス　0
    /// </summary>
    BRE,
    /// <summary>
    /// ブライトネス　64
    /// </summary>
    BRI,
    /// <summary>
    /// クリアネス　0
    /// </summary>
    CLE,
    /// <summary>
    /// オープニング　127
    /// </summary>
    OPE,
    /// <summary>
    /// ジェンダーファクター　64
    /// </summary>
    GEN,
    /// <summary>
    /// ポルタメントタイミング　64
    /// </summary>
    POR,
    /// <summary>
    /// ピッチベンド　0
    /// </summary>
    PIT,
    /// <summary>
    /// ピッチベンドセンシティビティ　2
    /// </summary>
    PBS,
}
