﻿/*
 * AviReaderEx.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;

using Boare.Lib.Media;

namespace LipSync {

    public class AviReaderEx : AviReader {
        private int m_num_openfailed = 0;

        /// <summary>
        /// aviファイルのOpenに失敗した累積回数を取得します
        /// </summary>
        public int NumFailed {
            get {
                return m_num_openfailed;
            }
        }


        public AviReaderEx() : base() {
            m_num_openfailed = 0;
        }


        public new void Open( string file ){
            try {
                base.Open( file );
            } catch {
                m_num_openfailed++;
            }
        }
    }

}
