﻿/*
 * CharacterConfigSpecifier.cs
 * Copyright (c) 2007-2009 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Drawing;

namespace LipSync {

    /// <summary>
    /// キャラクタ設定ファイルを識別するためのクラス
    /// </summary>
    public class CharacterConfigSpecifier {
        Image m_preview;
        string m_id;
        DateTime m_last_modefied;

        const int w = 256;
        const int h = 256;

        /// <summary>
        /// キャラクタ設定ファイルを特定するID．通常はファイルへのフルパス
        /// </summary>
        public string ID {
            get {
                return m_id;
            }
        }

        /// <summary>
        /// キャラクタ設定ファイルの最終更新時刻
        /// </summary>
        public DateTime LastModefied {
            get {
                return m_last_modefied;
            }
        }

        /// <summary>
        /// キャラクタ設定ファイルのプレビュー
        /// </summary>
        public Image Image {
            get {
                return m_preview;
            }
        }

        public CharacterConfigSpecifier( string id, DateTime date ) {
            m_id = id;
            m_last_modefied = date;
        }

        public CharacterConfigSpecifier( Character3 character, string id, DateTime date ) {
            if ( character != null ) {
                Bitmap bmp = character.DefaultFace;
                Rectangle rc = Common.GetNonTransparentRegion( bmp );
                using ( Bitmap t = new Bitmap( rc.Width, rc.Height ) )
                using ( Graphics g = Graphics.FromImage( t ) ) {
                    g.DrawImage(
                        bmp,
                        0, 0, rc, GraphicsUnit.Pixel );
                    m_preview = Common.GetThumbnailImage( t, w, h );
                }
            }
            m_id = id;
            m_last_modefied = date;
        }

        public CharacterConfigSpecifier( Character character, string id, DateTime date ) {
            if ( character != null ) {
                Bitmap bmp = character.DefaultFace;
                Rectangle rc = Common.GetNonTransparentRegion( bmp );
                using ( Bitmap t = new Bitmap( rc.Width, rc.Height ) )
                using ( Graphics g = Graphics.FromImage( t ) ) {
                    g.DrawImage(
                        bmp,
                        0, 0, rc, GraphicsUnit.Pixel );
                    m_preview = Common.GetThumbnailImage( t, w, h );
                }
            }
            m_id = id;
            m_last_modefied = date;
        }
    }

}
