﻿/*
 * ColorSet.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Drawing;

namespace LipSync {

    public class ColorSet {
        public int A = 255;
        public int R;
        public int G;
        public int B;

        public ColorSet( int alpha, int red, int green, int blue ) {
            if ( red < 0 || 255 < red ) {
                throw new ArgumentOutOfRangeException( "red" );
            }
            if ( green < 0 || 255 < green ) {
                throw new ArgumentOutOfRangeException( "green" );
            }
            if ( blue < 0 || 255 < blue ) {
                throw new ArgumentOutOfRangeException( "blue" );
            }
            if ( alpha < 0 || 255 < alpha ) {
                throw new ArgumentOutOfRangeException( "alpha" );
            }
            R = red;
            G = green;
            B = blue;
            A = alpha;
        }

        public ColorSet()
            : this( 255, 255, 255, 255 ) {
        }

        public ColorSet( int red, int green, int blue )
            : this( 255, red, green, blue ) {
        }

        public ColorSet( Color color )
            : this( color.A, color.R, color.G, color.B ) {
        }

        public ColorSet( int alpha, ColorSet color )
            : this( alpha, color.R, color.G, color.B ) {
        }

        public ColorSet( int alpha, Color color ) :
            this( alpha, color.R, color.G, color.B ) {
        }

        public Color Color {
            get {
                return Color.FromArgb( A, R, G, B );
            }
        }

        public override bool Equals( object obj ) {
            return Equals( obj, false );
        }

        public bool Equals( object obj, bool ignore_alpha ) {
            if ( obj is ColorSet ) {
                ColorSet item = (ColorSet)obj;
                if ( ignore_alpha ) {
                    return (item.R == R && item.G == G && item.B == B);
                } else {
                    return (item.A == A && item.R == R && item.G == G && item.B == B);
                }
            } else if ( obj is Color ) {
                Color item = (Color)obj;
                if ( ignore_alpha ) {
                    return (item.R == R && item.G == G && item.B == B);
                } else {
                    return (item.A == A && item.R == R && item.G == G && item.B == B);
                }
            } else {
                return base.Equals( obj );
            }
        }
    }

}
