/*
 * FormObjectList.cs
 * Copyright (c) 2007-2009 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System.Windows.Forms;

using Boare.Lib.AppUtil;

namespace LipSync {

    public partial class FormObjectList : Form {
        ListView m_listview;

        public static string _( string s ) {
            return Messaging.GetMessage( s );
        }

        protected override void WndProc( ref Message m ) {
            const int WM_NCLBUTTONDBLCLK = 0xa3;
            if ( m.Msg == WM_NCLBUTTONDBLCLK ) {
                this.Close();
            } else {
                base.WndProc( ref m );
            }
        }

        public FormObjectList() {
            InitializeComponent();
        }

        public new void Show( ListView listView ) {
            m_listview = listView;
            m_listview.Parent = this;
            this.Controls.Add( m_listview );
            m_listview.Dock = DockStyle.Fill;
            this.Text = _( "List of object" );
            base.Show();
        }

        private void FormObjectList_FormClosing( object sender, FormClosingEventArgs e ) {
            e.Cancel = true;
            this.Hide();
        }
    }

}
