﻿/*
 * SelectCharacter.cs
 * Copyright (c) 2007-2009 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Drawing;
using System.Collections.Generic;
using System.Windows.Forms;

using Boare.Lib.AppUtil;

namespace LipSync {

    public partial class SelectCharacater : Form, IMultiLanguageControl {
        Character3 m_character;
        string m_path;

        public SelectCharacater( List<string> plugins ) {
            InitializeComponent();
            ApplyLanguage();
            ApplyFont( AppManager.Config.Font.GetFont() );
            m_character = Character3.Miku;
            comboBox1.Items.Clear();
            for ( int i = 0; i < plugins.Count; i++ ) {
                comboBox1.Items.Add( plugins[i] );
            }
            if ( comboBox1.Items.Count == 0 ) {
                radioPlugin.Enabled = false;
            }
            chkImport.Checked = !AppManager.Config.SaveCharacterConfigOutside;
            chkImport.Enabled = false;
        }

        public void ApplyFont( Font font ) {
            this.Font = font;
            foreach ( Control c in this.Controls ) {
                Boare.Lib.AppUtil.Misc.ApplyFontRecurse( c, font );
            }
        }

        public void ApplyLanguage() {
            this.radioPlugin.Text = _( "Plugin" );
            this.radioCustom.Text = _( "Custom" );
            this.radioBuiltIn.Text = _( "Built-in" ) + " (Miku)";
            this.label1.Text = _( "Select character to generate lip-sync" );
            this.btnOK.Text = _( "OK" );
            this.btnCancel.Text = _( "Cancel" );
            this.radioRin.Text = _( "Built-in" ) + " (Rin)";
            this.radioLen.Text = _( "Built-in" ) + " (Len)";
            this.Text = _( "Character selection" );
        }

        private static string _( string s ) {
            return Messaging.GetMessage( s );
        }

        public string Path {
            get {
                return m_path;
            }
        }

        public Character3 Character {
            get {
                return m_character;
            }
        }

        private void btnOK_Click( object sender, EventArgs e ) {
            if ( radioBuiltIn.Checked ) {
                chkImport.Checked = false;
                this.DialogResult = DialogResult.OK;
                this.Close();
            } else if ( radioRin.Checked ) {
                chkImport.Checked = false;
                m_character = Character3.Rin;
                this.DialogResult = DialogResult.OK;
                this.Close();
            } else if ( radioLen.Checked ) {
                chkImport.Checked = false;
                m_character = Character3.Len;
                this.DialogResult = DialogResult.OK;
                this.Close();
            } else if ( radioCustom.Checked ) {
                GenerateCharacter gc = new GenerateCharacter( new Character3() );
                gc.LastPath = AppManager.Config.LastCharacterPath;
                if ( gc.ShowDialog() == DialogResult.OK ) {
                    //Form1.Instatnce.Config.LAST_CHARACTER_PATH = gc.LastPath;
                    m_character = gc.EditedResult.Character;
                    m_path = gc.LastPath;
                    this.DialogResult = DialogResult.OK;
                    this.Close();
                }
                gc.Dispose();
            } else {
                string id = (string)comboBox1.SelectedItem;
                int index = -1;
                for ( int i = 0; i < AppManager.SaveData.m_plugins_config.Count; i++ ) {
                    if ( id == AppManager.SaveData.m_plugins_config[i].ID ) {
                        index = i;
                        break;
                    }
                }
                if ( index >= 0 ) {
                    m_character = new Character3( AppManager.SaveData.m_plugins_config[index] );
                    this.DialogResult = DialogResult.OK;
                } else {
                    this.DialogResult = DialogResult.Cancel;
                }
                this.Close();
            }
        }

        private void radioPlugin_CheckedChanged( object sender, EventArgs e ) {
            comboBox1.Enabled = radioPlugin.Checked;
        }

        private void radioCustom_CheckedChanged( object sender, EventArgs e ) {
            chkImport.Enabled = radioCustom.Checked;
        }
    }

}
