/*
 * Decompiled with CFR 0.152.
 */
package jp.maru.liquid.core.plugins;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import jp.maru.liquid.core.plugins.http.ActionEngine;
import jp.maru.liquid.core.plugins.http.HttpFileNotFoundException;
import jp.maru.liquid.core.plugins.http.HttpServerException;
import jp.maru.liquid.plugin.HttpServerPlugin;
import jp.maru.liquid.plugin.HttpTemplatePlugin;
import jp.maru.liquid.plugin.http.HttpRequest;
import jp.maru.liquid.plugin.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpActionPlugin
implements HttpServerPlugin,
HttpTemplatePlugin {
    private static final Logger logger = LoggerFactory.getLogger(HttpActionPlugin.class);
    private static final int MAX_FORWARD = 10;
    private String _bindUri;
    private String _encoding;
    private String _templatePath;
    private String _actionClass;

    @Override
    public void init() {
    }

    @Override
    public String action(HttpRequest request, HttpResponse response, Map<String, Object> modelMap) {
        int forwardCounter = 0;
        try {
            ActionEngine engine = new ActionEngine(this._actionClass, request, response);
            engine.setContentType("text/html");
            engine.setCharacterEncoding(this._encoding);
            engine.setModelMap(modelMap);
            String templateName = engine.execute();
            if (templateName == null) {
                return null;
            }
            do {
                if (!templateName.endsWith("()")) {
                    if (templateName.startsWith(">")) {
                        String redirectLocation = templateName.substring(1);
                        response.sendRedirect(redirectLocation);
                        return null;
                    }
                    return templateName;
                }
                int delim = templateName.indexOf(47);
                String actionName = templateName.substring(0, delim);
                String methodName = templateName.substring(delim + 1, templateName.length() - 2);
                templateName = engine.execute(actionName, methodName);
            } while (forwardCounter++ < 10);
            return null;
        }
        catch (ClassNotFoundException cnfe) {
            logger.warn("Action is not found. " + request.getRequestURI());
            return null;
        }
        catch (UnsupportedEncodingException se) {
            logger.error("Encoding is unsupported. " + this._encoding);
            return null;
        }
        catch (HttpServerException hse) {
            logger.warn(hse.getMessage());
            if (hse instanceof HttpFileNotFoundException) {
                HttpActionPlugin.sendError(response, 404);
            }
            return null;
        }
    }

    @Override
    public void setBindURI(String uri) {
        this._bindUri = uri;
    }

    @Override
    public String getBindURI() {
        return this._bindUri;
    }

    public void setTemplatePath(String templatePath) {
        this._templatePath = templatePath;
    }

    @Override
    public String getTemplatePath() {
        return this._templatePath;
    }

    public void setActionClass(String actionClass) {
        this._actionClass = actionClass;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    private static void sendError(HttpResponse response, int sc) {
        try {
            response.sendError(404);
        }
        catch (IOException ioe) {
            logger.warn(ioe.getMessage(), (Throwable)ioe);
        }
    }

    public String toString() {
        return "HttpActionPlugin";
    }
}

