/*
 * Decompiled with CFR 0.152.
 */
package jp.maru.liquid.core.plugins.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.maru.liquid.core.plugins.http.ActionError;
import jp.maru.liquid.core.plugins.http.util.ActionModelMap;
import jp.maru.liquid.plugin.http.HttpRequest;
import jp.maru.liquid.plugin.http.HttpResponse;
import jp.maru.liquid.util.StringHashMap;

public class ActionContext {
    private ArrayList<ActionError> _actionErrors;
    private Map<String, Object> _contextMap;
    private Map<String, Object> _parameterMap;
    private Map<String, Object> _sessionMap;
    private Map<String, String> _errorMap;
    private HttpRequest _request;
    private HttpResponse _response;

    public ActionContext(Map<String, Object> context) {
        this._contextMap = context;
        this._actionErrors = new ArrayList();
        this._errorMap = new StringHashMap<String, String>();
        this._contextMap.put("errors", this._errorMap);
    }

    public void setAction(Object actionObject) {
        this._contextMap.put("action", new ActionModelMap(actionObject));
    }

    public Map<String, Object> getParameters() {
        return this._parameterMap;
    }

    public void setParameters(Map<String, Object> parameters) {
        this._parameterMap = parameters;
        this._contextMap.put("params", parameters);
    }

    public void addActionError(ActionError actionError) {
        this._actionErrors.add(actionError);
        this._errorMap.put(actionError.getPropertyName(), actionError.getMessage());
    }

    public List<ActionError> getActionErrors() {
        List actionErrors = (List)this._actionErrors.clone();
        return actionErrors;
    }

    public Map<String, Object> getContextMap() {
        return this._contextMap;
    }

    public HttpRequest getRequest() {
        return this._request;
    }

    public void setRequest(HttpRequest request) {
        this._request = request;
    }

    public HttpResponse getResponse() {
        return this._response;
    }

    public void setResponse(HttpResponse response) {
        this._response = response;
    }

    public Map<String, Object> getSession() {
        return this._sessionMap;
    }

    public void setSession(Map<String, Object> session) {
        this._sessionMap = session;
        this._contextMap.put("session", session);
    }
}

