/*
 * Decompiled with CFR 0.152.
 */
package jp.maru.liquid.core.plugins.http;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import jp.maru.liquid.core.GuiceModule;
import jp.maru.liquid.core.plugins.http.ActionContext;
import jp.maru.liquid.core.plugins.http.ActionProxy;
import jp.maru.liquid.core.plugins.http.ActionProxyFactory;
import jp.maru.liquid.core.plugins.http.HttpServerException;
import jp.maru.liquid.core.plugins.http.SessionMap;
import jp.maru.liquid.core.plugins.http.util.ActionHelper;
import jp.maru.liquid.plugin.http.HttpRequest;
import jp.maru.liquid.plugin.http.HttpResponse;

public class ActionEngine {
    private static String DEFAULT_METHOD = "index";
    private HttpRequest _request;
    private HttpResponse _response;
    private String _contentType = "text/html";
    private String _characterEncoding;
    private String _actionName;
    private String _actionClass;
    private Map<String, Object> _modelMap;
    private boolean _initRequest;
    private ActionContext _actionContext;
    private ActionProxyFactory _actionProxyFactory;

    public ActionEngine(String actionClass, HttpRequest request, HttpResponse response) {
        if (actionClass == null) {
            throw new NullPointerException("ActionClass is null.");
        }
        if (request == null) {
            throw new NullPointerException("HttpRequest is null.");
        }
        if (response == null) {
            throw new NullPointerException("HttpResponse is null.");
        }
        this._actionClass = actionClass;
        this._request = request;
        this._response = response;
        Injector injector = Guice.createInjector((Module[])new Module[]{new GuiceModule()});
        injector.injectMembers((Object)this);
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
        StringBuilder responseContentType = new StringBuilder();
        responseContentType.append(contentType);
        if (this._characterEncoding != null) {
            responseContentType.append("; charset=").append(this._characterEncoding);
        }
        this._response.setContentType(responseContentType.toString());
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this._characterEncoding = encoding;
        this._request.setCharacterEncoding(encoding);
        this._response.setContentType(this._contentType + "; charset=" + encoding);
    }

    public void setModelMap(Map<String, Object> modelMap) {
        this._modelMap = modelMap;
    }

    private void initRequest() {
        if (!this._initRequest) {
            this._actionName = this._request.getRequestURI().substring(this._request.getRequestURI().indexOf(47, 1) + 1);
            if (this._modelMap == null) {
                this._modelMap = new HashMap<String, Object>();
            }
            this._actionContext = new ActionContext(this._modelMap);
            this._actionContext.setParameters(ActionHelper.getParameters(this._request));
            this._actionContext.setRequest(this._request);
            this._actionContext.setResponse(this._response);
            this._actionContext.setSession(new SessionMap<String, Object>(this._request));
            this._initRequest = true;
        }
    }

    public String execute() throws HttpServerException, ClassNotFoundException {
        this.initRequest();
        return this.execute(this._actionName, DEFAULT_METHOD);
    }

    public String execute(String actionName, String methodName) throws HttpServerException, ClassNotFoundException {
        this.initRequest();
        int slashPos = actionName.indexOf(47);
        if (slashPos > -1) {
            if (slashPos != actionName.length() - 1) {
                methodName = actionName.substring(slashPos + 1);
            }
            actionName = actionName.substring(0, slashPos);
        }
        Class<?> action = Class.forName(this._actionClass.replace("*", actionName));
        ActionProxy actionProxy = this._actionProxyFactory.createActionProxy(this._request, this._actionContext, action, methodName);
        return actionProxy.execute();
    }

    @Inject
    public void setActionProxyFactory(ActionProxyFactory actionProxyFactory) {
        this._actionProxyFactory = actionProxyFactory;
    }
}

