/*
 * Decompiled with CFR 0.152.
 */
package jp.maru.liquid.core.plugins.http;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.maru.liquid.plugin.http.HttpRequest;
import jp.maru.liquid.plugin.http.HttpSession;

public class SessionMap<K, V>
extends AbstractMap<K, V> {
    protected HttpSession _session;
    protected Set<Map.Entry<K, V>> _entries;
    protected HttpRequest _request;

    public SessionMap(HttpRequest request) {
        this._request = request;
        this._session = this._request.getSession(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this._session == null) {
            return;
        }
        HttpSession httpSession = this._session;
        synchronized (httpSession) {
            this._entries = null;
            Enumeration<String> attributeNamesEnum = this._session.getAttributeNames();
            while (attributeNamesEnum.hasMoreElements()) {
                this._session.removeAttribute(attributeNamesEnum.nextElement());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this._session == null) {
            return Collections.emptySet();
        }
        HttpSession httpSession = this._session;
        synchronized (httpSession) {
            if (this._entries == null) {
                this._entries = new HashSet<Map.Entry<K, V>>();
                Enumeration<String> enumeration = this._session.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    final String key = enumeration.nextElement().toString();
                    final Object value = this._session.getAttribute(key);
                    this._entries.add(new Map.Entry<K, V>(){

                        @Override
                        public boolean equals(Object obj) {
                            Map.Entry entry = (Map.Entry)obj;
                            return (key == null ? entry.getKey() == null : key.equals(entry.getKey())) && (value == null ? entry.getValue() == null : value.equals(entry.getValue()));
                        }

                        @Override
                        public int hashCode() {
                            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
                        }

                        @Override
                        public K getKey() {
                            return key;
                        }

                        @Override
                        public V getValue() {
                            return value;
                        }

                        @Override
                        public V setValue(Object obj) {
                            SessionMap.this._session.setAttribute(key, obj);
                            return value;
                        }
                    });
                }
            }
        }
        return this._entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        if (this._session == null) {
            return null;
        }
        HttpSession httpSession = this._session;
        synchronized (httpSession) {
            return (V)this._session.getAttribute(key.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Object object = this;
        synchronized (object) {
            if (this._session == null) {
                this._session = this._request.getSession(true);
            }
        }
        object = this._session;
        synchronized (object) {
            this._entries = null;
            this._session.setAttribute(key.toString(), value);
            return this.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        if (this._session == null) {
            return null;
        }
        HttpSession httpSession = this._session;
        synchronized (httpSession) {
            this._entries = null;
            V value = this.get(key);
            this._session.removeAttribute(key.toString());
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        if (this._session == null) {
            return false;
        }
        HttpSession httpSession = this._session;
        synchronized (httpSession) {
            return this._session.getAttribute(key.toString()) != null;
        }
    }
}

