/*
 * Decompiled with CFR 0.152.
 */
package jp.maru.liquid.core.plugins.http.interceptor;

import java.util.HashMap;
import jp.maru.liquid.core.plugins.http.ActionInvocation;
import jp.maru.liquid.core.plugins.http.interceptor.CookiesAware;
import jp.maru.liquid.core.plugins.http.interceptor.Interceptor;
import jp.maru.liquid.plugin.http.Cookie;
import jp.maru.liquid.plugin.http.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(CookieInterceptor.class);

    @Override
    public String intercept(ActionInvocation invocation) {
        Object action = invocation.getAction();
        if (action instanceof CookiesAware) {
            HttpRequest request = invocation.getInvocationContext().getRequest();
            Cookie[] cookies = request.getCookies();
            HashMap<String, String> cookieMap = new HashMap<String, String>();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Cookie -> " + cookie.getName() + " = " + cookie.getValue());
                    }
                    cookieMap.put(cookie.getName(), cookie.getValue());
                }
            }
            ((CookiesAware)action).setCookiesMap(cookieMap);
        }
        return invocation.invoke();
    }
}

