/*
 * Decompiled with CFR 0.152.
 */
package jp.maru.liquid.core.plugins.http.interceptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import jp.maru.liquid.core.plugins.http.ActionContext;
import jp.maru.liquid.core.plugins.http.ActionError;
import jp.maru.liquid.core.plugins.http.ActionErrorProxy;
import jp.maru.liquid.core.plugins.http.ActionInvocation;
import jp.maru.liquid.core.plugins.http.annotation.validator.RequiredStringValidator;
import jp.maru.liquid.core.plugins.http.annotation.validator.StringLengthFieldValidator;
import jp.maru.liquid.core.plugins.http.annotation.validator.ValidateTransferMyself;
import jp.maru.liquid.core.plugins.http.annotation.validator.Validation;
import jp.maru.liquid.core.plugins.http.interceptor.ErrorsAware;
import jp.maru.liquid.core.plugins.http.interceptor.Interceptor;
import jp.maru.liquid.core.plugins.http.util.ActionHelper;
import org.apache.commons.validator.GenericValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(ValidationInterceptor.class);

    @Override
    public String intercept(ActionInvocation actionInvocation) {
        try {
            Map<String, Object> sessionMap;
            Object sessionAction;
            Object action = actionInvocation.getAction();
            final ActionContext context = actionInvocation.getInvocationContext();
            if (action instanceof ErrorsAware) {
                ActionErrorProxy proxy = new ActionErrorProxy(){

                    @Override
                    public void addActionError(ActionError actionError) {
                        context.addActionError(actionError);
                    }
                };
                ((ErrorsAware)action).setActionErrorProxy(proxy);
            }
            Map<String, Object> paramMap = context.getParameters();
            String methodName = actionInvocation.getProxy().getMethod();
            Method actionMethod = action.getClass().getMethod(methodName, new Class[0]);
            Validation validation = actionMethod.getAnnotation(Validation.class);
            ValidateTransferMyself validateTrans = actionMethod.getAnnotation(ValidateTransferMyself.class);
            if (validateTrans != null && (sessionAction = (sessionMap = context.getSession()).get(action.getClass().toString())) != action) {
                return validateTrans.failedReturn();
            }
            if (validation != null) {
                Method[] methods;
                for (Method method : methods = action.getClass().getMethods()) {
                    Annotation[] annotations;
                    if (!method.getName().startsWith("set")) continue;
                    String paramName = Character.toLowerCase(method.getName().charAt(3)) + method.getName().substring(4);
                    String paramValue = (String)paramMap.get(paramName);
                    for (Annotation annotation : annotations = method.getDeclaredAnnotations()) {
                        int length;
                        if (annotation instanceof RequiredStringValidator && GenericValidator.isBlankOrNull((String)paramValue)) {
                            context.addActionError(new ActionError(paramName, ((RequiredStringValidator)annotation).message()));
                        }
                        if (!(annotation instanceof StringLengthFieldValidator) || GenericValidator.isBlankOrNull((String)paramValue)) continue;
                        StringLengthFieldValidator validator = (StringLengthFieldValidator)annotation;
                        int minLength = validator.minLength();
                        int maxLength = validator.maxLength();
                        int n = length = validator.trim() ? paramValue.trim().length() : paramValue.length();
                        if ((minLength == -1 || length >= minLength) && (maxLength == -1 || length <= maxLength)) continue;
                        context.addActionError(new ActionError(paramName, validator.message()));
                    }
                }
            }
            int invokeCount = 1;
            String result = null;
            do {
                if (context.getActionErrors().size() > 0 && validation != null) {
                    if (validation.valueConvert() == Validation.ConvertType.JSON) {
                        return ActionHelper.convertErrorToJSON(context);
                    }
                    return validation.failedReturn();
                }
                if (invokeCount <= 0) continue;
                result = actionInvocation.invoke();
            } while (invokeCount-- > 0);
            return result;
        }
        catch (NoSuchMethodException nsme) {
            logger.error(nsme.toString(), (Throwable)nsme);
            return null;
        }
    }
}

