/*
 * Decompiled with CFR 0.152.
 */
package jp.maru.liquid.kernel;

import java.util.ArrayList;
import java.util.List;
import jp.maru.liquid.annotation.Plug;
import jp.maru.liquid.kernel.PluginManager;
import jp.maru.liquid.kernel.modules.Module;
import jp.maru.liquid.kernel.modules.strategy.Strategy;
import jp.maru.liquid.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleManager {
    private static final Logger logger = LoggerFactory.getLogger(ModuleManager.class);
    private List<Module> _modules = new ArrayList<Module>();

    ModuleManager() {
    }

    public void setModules(List<Module> modules) {
        logger.info("Loading modules...");
        for (Module module : modules) {
            this._modules.add(module);
            Strategy st = module.getStrategy();
            logger.info("+ " + module.getClass().getSimpleName() + (st != null ? "[" + st.getClass().getSimpleName() + "]" : ""));
        }
    }

    public void initModules() {
        for (Module module : this._modules) {
            logger.info("Initialize " + module.getClass().getSimpleName());
            module.init();
        }
    }

    void plugPlugins(PluginManager pluginManager) {
        try {
            for (Module module : this._modules) {
                Strategy strategy = module.getStrategy();
                Plug plug = module.getClass().getMethod("plug", Plugin.class).getAnnotation(Plug.class);
                Class<? extends Plugin> pluginClass = plug.value();
                Class<? extends Plugin> strategyPluginClass = null;
                if (strategy != null) {
                    Plug strategyPlug = strategy.getClass().getAnnotation(Plug.class);
                    strategyPluginClass = strategyPlug.value();
                }
                for (Plugin plugin : pluginManager.getPlugins()) {
                    if (!pluginClass.isInstance(plugin) || strategyPluginClass != null && (strategyPluginClass == null || !strategyPluginClass.isInstance(plugin))) continue;
                    logger.info("Plug " + plugin.getClass().getSimpleName() + " to " + module.getClass().getSimpleName() + (strategy != null ? "[" + strategy.getClass().getSimpleName() + "]" : ""));
                    module.plug(plugin);
                }
            }
        }
        catch (NoSuchMethodException nsme) {
            logger.error("Plug error.", (Throwable)nsme);
            throw new RuntimeException("Plug error.", nsme);
        }
    }
}

