/*
 * Decompiled with CFR 0.152.
 */
package jp.maru.liquid.kernel.modules;

import java.io.IOException;
import jp.maru.liquid.annotation.Plug;
import jp.maru.liquid.kernel.modules.AbstractModule;
import jp.maru.liquid.kernel.modules.http.AbstractNHttpRequestHandler;
import jp.maru.liquid.kernel.modules.http.DefaultHttpListener;
import jp.maru.liquid.kernel.modules.http.HttpConnector;
import jp.maru.liquid.kernel.modules.http.HttpCoreRequest;
import jp.maru.liquid.kernel.modules.http.HttpCoreResponse;
import jp.maru.liquid.kernel.modules.strategy.HttpStrategy;
import jp.maru.liquid.kernel.modules.strategy.Strategy;
import jp.maru.liquid.plugin.HttpServerCommonPlugin;
import jp.maru.liquid.plugin.HttpServerPlugin;
import jp.maru.liquid.plugin.Plugin;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.NHttpResponseTrigger;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerModule
extends AbstractModule {
    private static final Logger logger = LoggerFactory.getLogger(HttpServerModule.class);
    protected HttpConnector _connector;
    protected HttpStrategy _strategy;

    @Override
    public void init() {
        if (!this._connector.isListened()) {
            this._connector.listen();
        }
    }

    @Override
    public void setStrategy(Strategy strategy) {
        this._strategy = (HttpStrategy)strategy;
    }

    @Override
    public Strategy getStrategy() {
        return this._strategy;
    }

    @Override
    @Plug(value=HttpServerPlugin.class)
    public void plug(Plugin plugin) {
        HttpServerPlugin plugin0 = (HttpServerPlugin)plugin;
        this._connector.register(plugin0, new SyncNHttpRequestHandlerImpl(plugin0));
    }

    public void setConnector(HttpConnector connector) {
        this._connector = connector;
    }

    public String toString() {
        return "HttpServerModule";
    }

    class SyncNHttpRequestHandlerImpl
    extends AbstractNHttpRequestHandler {
        private HttpServerCommonPlugin _plugin;

        SyncNHttpRequestHandlerImpl(HttpServerCommonPlugin plugin) {
            this._plugin = plugin;
        }

        public void handle(HttpRequest request, HttpResponse response, NHttpResponseTrigger trriger, HttpContext context) throws HttpException, IOException {
            HttpServerModule.this.callPreProcess();
            HttpCoreRequest coreRequest = new HttpCoreRequest(request);
            HttpCoreResponse coreResponse = new HttpCoreResponse(response);
            coreRequest.setHttpGenericListener(new DefaultHttpListener(coreRequest, coreResponse));
            HttpServerModule.this._strategy.execute(this._plugin, coreRequest, coreResponse);
            coreResponse.flushBuffer();
            HttpServerModule.this.callPostProcess();
            trriger.submitResponse(response);
        }
    }
}

